/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.drc.Quick;
import com.sun.electric.tool.extract.LayerCoverageTool;
import com.sun.electric.tool.generator.PadGenerator;
import com.sun.electric.tool.generator.ROMGenerator;
import com.sun.electric.tool.generator.cmosPLA.PLA;
import com.sun.electric.tool.generator.layout.GateRegression;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.fill.FillGenConfig;
import com.sun.electric.tool.generator.layout.fill.FillGeneratorTool;
import com.sun.electric.tool.generator.layout.fill.StitchFillJob;
import com.sun.electric.tool.generator.layout.fillCell.FillCellGenJob;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.sc.SilComp;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.ToolMenu;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizardData;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.tool.user.tests.DRCTest;
import com.sun.electric.util.TextUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class GenerationTest
extends AbstractTest {
    GenerationTest(String name) {
        super(name);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new GenerationTest("FillTemplate"));
        list.add(new GenerationTest("FillStitch"));
        list.add(new GenerationTest("PLA"));
        list.add(new GenerationTest("PadFrame1"));
        list.add(new GenerationTest("PadFrame2"));
        list.add(new GenerationTest("ROM"));
        list.add(new GenerationTest("SiliconCompiler1"));
        list.add(new GenerationTest("SiliconCompiler2"));
        list.add(new GenerationTest("TechEditWizard"));
        list.add(new GenerationTest("GateGen"));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/Generation/output/";
    }

    public Boolean FillTemplate() {
        return GenerationTest.basicTemplateFillTest(this.getRegressionPath());
    }

    public static Boolean basicTemplateFillTest(String rootPath) {
        String trueRootPath = rootPath != null ? rootPath + "/tools/Generation/" : "";
        String outputDir = trueRootPath + "output/";
        GenerationTest.ensureOutputDirectory(outputDir);
        MessagesStream.getMessagesStream().save(outputDir + "TemplateFillOut.log");
        int[] cells = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
        double drcSpacingRule = 6.0;
        double vddReserve = drcSpacingRule * 2.0;
        double gndReserve = drcSpacingRule * 3.0;
        Technology tech = Technology.getMocmosTechnology();
        GenerationTest.setFoundry(tech);
        String rootName = "autoFillTemplateLib";
        FillGenConfig config = new FillGenConfig(tech, FillGeneratorTool.FillTypeEnum.TEMPLATE, rootName, FillGeneratorTool.PERIMETER, 2, 6, 100.0, 200.0, true, cells, true, 0.1, drcSpacingRule, false, false, false, 0.0, FillGenConfig.FillGenType.INTERNAL, -1);
        config.reserveSpaceOnLayer(tech, 3, vddReserve, FillGeneratorTool.LAMBDA, gndReserve, FillGeneratorTool.LAMBDA);
        config.reserveSpaceOnLayer(tech, 4, vddReserve, FillGeneratorTool.LAMBDA, gndReserve, FillGeneratorTool.LAMBDA);
        FillCellGenJob job = new FillCellGenJob(null, config, true, new LayerCoverageTool.LayerCoveragePreferences(true));
        Library lib = Library.findLibrary(rootName);
        boolean sameLib = GenerationTest.compareLibraryResults(trueRootPath, rootName, lib, new char[]{'H', 'C', 'F', 'R', 'T', 'O', '#'});
        Cell cell = job.getAutoFilLibrary().findNodeProto("gallery");
        GenerationTest.setFoundry(tech);
        boolean passed = DRCTest.basicDRCLayoutTestInternal(cell, 0, 0, 0, 0, 0, 0, false, DRC.DRCCheckMinArea.AREA_LOCAL);
        if (!sameLib) {
            System.out.println("Error: TemplateFill didn't generate expected results");
        }
        if (!passed) {
            System.out.println("Error: TemplateFill didn't pass DRC");
        }
        return passed && sameLib;
    }

    public Boolean FillStitch() {
        return GenerationTest.basicStitchFillGenTest(this.getRegressionPath());
    }

    public static boolean basicStitchFillGenTest(String rootPath) {
        int foundDRCErrors;
        int foundCells;
        String trueRootPath = rootPath != null ? rootPath + "/tools/Generation/" : "";
        String outputDir = trueRootPath + "output/";
        GenerationTest.ensureOutputDirectory(outputDir);
        MessagesStream.getMessagesStream().save(outputDir + "StitchFillOut.log");
        int expectedNumCells = 1;
        int expectedDRCNumErrors = 0;
        boolean sameLib = false;
        try {
            String rootName;
            String testcell;
            Cell cell;
            Technology tech = Technology.getMocmosTechnology();
            GenerationTest.setFoundry(tech);
            EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
            String libName = "GenerationTests";
            URL fileURL = TextUtils.makeURLToFile(trueRootPath + "data/libs/GenerationTests.jelib");
            Library rootLib = Library.findLibrary(libName);
            if (rootLib == null) {
                rootLib = LibraryFiles.readLibrary(ep, fileURL, libName, FileType.JELIB, true);
            }
            if ((cell = rootLib.findNodeProto(testcell = (rootName = "StitchFill") + "{doc}")) == null) {
                System.out.println("Cell '" + testcell + "' can't be read in basicStitchFillGenTest");
                return false;
            }
            fileURL = TextUtils.makeURLToFile(trueRootPath + "output/" + rootName + ".jelib");
            Library lib = Library.newInstance(rootName, fileURL);
            StitchFillJob job = new StitchFillJob(cell, lib, true);
            List<Cell> list = job.getGeneratedCells();
            foundCells = list.size();
            assert (foundCells == 1);
            sameLib = GenerationTest.compareLibraryResults(trueRootPath, rootName, lib, new char[]{'H', 'C', 'F', 'R', 'T', 'O', '#'});
            GenerationTest.setFoundry(tech);
            boolean passed = DRCTest.basicDRCLayoutTestInternal(cell, 0, 0, 0, 0, 0, 0, false, DRC.DRCCheckMinArea.AREA_LOCAL);
            foundDRCErrors = passed ? 0 : 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        boolean noErrors = foundCells == expectedNumCells && foundDRCErrors == expectedDRCNumErrors && sameLib;
        System.out.println("Expected results: ");
        System.out.println("\t#cells generated=" + expectedNumCells + "(found=" + foundCells + ")");
        System.out.println("\t#DRC errors=" + expectedDRCNumErrors + "(found=" + foundDRCErrors + ")");
        System.out.println("\tGenerated same library?: " + sameLib);
        return noErrors;
    }

    public Boolean PLA() {
        return GenerationTest.basicPLATest(this.getRegressionPath());
    }

    public static boolean basicPLATest(String rootPath) {
        String trueRootPath = rootPath != null ? rootPath + "/tools/Generation/" : "";
        String outputDir = trueRootPath + "output/";
        GenerationTest.ensureOutputDirectory(outputDir);
        MessagesStream.getMessagesStream().save(outputDir + "CMOSPLA1Out.log");
        boolean good = true;
        try {
            GenerationTest.setFoundry(Technology.getMocmosTechnology());
            Library lib = Library.newInstance("CMOSPLA1Result", null);
            String libDir = trueRootPath + "data/libs/";
            PLA.generate(lib, "pla", libDir + "/cmos-pla-and-table", libDir + "/cmos-pla-or-table", true, true, true);
            Date zeroDate = new Date(0L);
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                cell.lowLevelSetCreationDate(zeroDate);
                cell.lowLevelSetRevisionDate(zeroDate);
            }
            lib.getDatabase().backup();
            if (!GenerationTest.compareLibraryResults(trueRootPath, "CMOSPLA1", lib, new char[]{'H', 'L', 'F', 'R', 'T', 'O', '#'})) {
                good = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            good = false;
        }
        return good;
    }

    public Boolean PadFrame1() {
        return GenerationTest.basicPadFrameTest(this.getRegressionPath(), 1);
    }

    public Boolean PadFrame2() {
        return GenerationTest.basicPadFrameTest(this.getRegressionPath(), 2);
    }

    public static boolean basicPadFrameTest(String rootPath, int testNumber) {
        String trueRootPath = rootPath != null ? rootPath + "/tools/Generation/" : "";
        String outputDir = trueRootPath + "output/";
        GenerationTest.ensureOutputDirectory(outputDir);
        MessagesStream.getMessagesStream().save(outputDir + "PadFrame" + testNumber + "Out.log");
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        boolean good = true;
        try {
            GenerationTest.setFoundry(Technology.getMocmosTechnology());
            String libName = "Generation" + testNumber + "Tests";
            URL fileURL = TextUtils.makeURLToFile(trueRootPath + "data/libs/GenerationTests.jelib");
            Library lib = Library.findLibrary(libName);
            if (lib == null) {
                lib = LibraryFiles.readLibrary(ep, fileURL, libName, FileType.JELIB, true);
            }
            String arrFile = "pads4u.arr";
            if (testNumber == 2) {
                arrFile = "pads4uGapCopy.arr";
            }
            PadGenerator.makePadFrameUseJob(lib, trueRootPath + "data/libs/" + arrFile, null, ep);
            Cell c = lib.findNodeProto("padframe");
            if (c != null) {
                c.lowLevelSetCreationDate(new Date(0L));
                c.lowLevelSetRevisionDate(new Date(0L));
            }
            lib.getDatabase().backup();
            String destLib = outputDir + "PadFrame" + testNumber + "Result.jelib";
            Output.saveJelib(destLib, lib);
            String trimmedLib = outputDir + "PadFrame" + testNumber + "ResultPartial.jelib";
            GenerationTest.trimLibToCell(destLib, trimmedLib, "padframe");
            String expectedLib = trueRootPath + "data/expected/PadFrame" + testNumber + "Result.jelib";
            if (!GenerationTest.compareResults(trimmedLib, expectedLib)) {
                good = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            good = false;
        }
        return good;
    }

    public Boolean ROM() {
        return GenerationTest.basicROMTest(this.getRegressionPath());
    }

    public static boolean basicROMTest(String rootPath) {
        String trueRootPath = rootPath != null ? rootPath + "/tools/Generation/" : "";
        String outputDir = trueRootPath + "output/";
        GenerationTest.ensureOutputDirectory(outputDir);
        MessagesStream.getMessagesStream().save(outputDir + "ROM1Out.log");
        boolean good = true;
        try {
            GenerationTest.setFoundry(Technology.getMocmosTechnology());
            Library lib = Library.newInstance("rom", null);
            EditingPreferences ep = new EditingPreferences(true, lib.getTechPool());
            String libDir = trueRootPath + "data/libs/";
            ROMGenerator.generateROM(lib, libDir + "rom.txt", ep);
            Date zeroDate = new Date(0L);
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                cell.lowLevelSetCreationDate(zeroDate);
                cell.lowLevelSetRevisionDate(zeroDate);
            }
            lib.getDatabase().backup();
            if (!GenerationTest.compareLibraryResults(trueRootPath, "ROM1", lib, new char[]{'H', 'L', 'F', 'R', 'T', 'O', '#'})) {
                good = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            good = false;
        }
        return good;
    }

    public Boolean SiliconCompiler1() {
        return GenerationTest.basicSiliconCompilerTest(this.getRegressionPath(), 1);
    }

    public Boolean SiliconCompiler2() {
        return GenerationTest.basicSiliconCompilerTest(this.getRegressionPath(), 2);
    }

    public static boolean basicSiliconCompilerTest(String rootPath, int testNumber) {
        String trueRootPath = rootPath != null ? rootPath + "/tools/Generation/" : "";
        String outputDir = trueRootPath + "output/";
        GenerationTest.ensureOutputDirectory(outputDir);
        MessagesStream.getMessagesStream().save(outputDir + "SiliconCompilation" + testNumber + "Out.log");
        boolean good = true;
        try {
            SilComp.SilCompPrefs prefs;
            Cell lay;
            String trimStr;
            GenerationTest.setFoundry(Technology.getMocmosTechnology());
            EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
            String libName = "GenerationTests";
            URL fileURL = TextUtils.makeURLToFile(trueRootPath + "data/libs/GenerationTests.jelib");
            Library lib = Library.findLibrary(libName);
            if (lib == null) {
                lib = LibraryFiles.readLibrary(ep, fileURL, libName, FileType.JELIB, true);
            }
            if (testNumber == 1) {
                trimStr = "ACC;";
                lay = lib.findNodeProto("tool-SiliconCompiler{vhdl}");
                prefs = new SilComp.SilCompPrefs(true, Technology.getMocmosTechnology().getTechName());
                ToolMenu.doSiliconCompilation(lay, true, prefs, ep);
                String destLibA = outputDir + "SiliconCompilation1ResultA.jelib";
                Output.saveJelib(destLibA, lib);
            } else {
                trimStr = "adder4;";
                lay = lib.findNodeProto("adder4{vhdl}");
                prefs = new SilComp.SilCompPrefs(true, Technology.getMocmosTechnology().getTechName());
                ToolMenu.doSilCompActivityNoJob(lay, 2, prefs, true);
            }
            Date zeroDate = new Date(0L);
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                cell.lowLevelSetCreationDate(zeroDate);
                cell.lowLevelSetRevisionDate(zeroDate);
            }
            lib.getDatabase().backup();
            String destLib = outputDir + "SiliconCompilation" + testNumber + "Result.jelib";
            Output.saveJelib(destLib, lib);
            String trimmedLib = outputDir + "SiliconCompilation" + testNumber + "ResultPartial.jelib";
            GenerationTest.trimLibToCell(destLib, trimmedLib, trimStr);
            String expectedLib = trueRootPath + "data/expected/SiliconCompilation" + testNumber + "Result.jelib";
            if (!GenerationTest.compareResults(trimmedLib, expectedLib)) {
                good = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            good = false;
        }
        return good;
    }

    public Boolean TechEditWizard() {
        return GenerationTest.basicTechEditWizardTest(this.getRegressionPath());
    }

    public static boolean basicTechEditWizardTest(String rootPath) {
        String trueRootPath = rootPath != null ? rootPath + "/tools/Generation/" : "";
        String outputDir = trueRootPath + "output/";
        GenerationTest.ensureOutputDirectory(outputDir);
        MessagesStream.getMessagesStream().save(outputDir + "TechEditWizardOut.log");
        boolean good = true;
        try {
            GenerationTest.setFoundry(Technology.getMocmosTechnology());
            TechEditWizardData data = new TechEditWizardData();
            String destLib = trueRootPath + "output/MoCmos.xml";
            data.importDataFromWizardFormat(trueRootPath + "data/libs/mocmos.txt");
            data.dumpXMLFile(destLib);
            String trimmedLib = trueRootPath + "output/MoCmosPartial.xml";
            GenerationTest.removeLines(destLib, trimmedLib, " *");
            String expectedLib = trueRootPath + "data/expected/TechEditWizardMoCmos.xml";
            if (!GenerationTest.compareResults(trimmedLib, expectedLib)) {
                good = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            good = false;
        }
        return good;
    }

    public Boolean GateGen() {
        return GenerationTest.basicGateGenerationTest(this.getRegressionPath());
    }

    public static boolean basicGateGenerationTest(String rootPath) {
        boolean cleanDRC;
        String trueRootPath = rootPath != null ? rootPath + "/tools/Generation/" : "";
        String outputDir = trueRootPath + "output/";
        GenerationTest.ensureOutputDirectory(outputDir);
        MessagesStream.getMessagesStream().save(outputDir + "GateGen.log");
        int numErrs = 0;
        boolean sameLib = false;
        try {
            String libName = trueRootPath + "data/libs/purpleFour.jelib";
            System.out.println("Opening " + libName);
            EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
            LayoutLib.openLibForRead(libName, ep, true);
            Library scratchLib = Library.newInstance("GateGenScratch", TextUtils.makeURLToFile(outputDir + "GateGenScratch.jelib"));
            Technology tech = Technology.getMocmosTechnology();
            tech = GenerationTest.setFoundry(tech);
            GateRegression.runRegression(tech, scratchLib, IOTool.getBackupRedundancy(), ep);
            sameLib = GenerationTest.compareLibraryResults(trueRootPath, scratchLib.getName(), scratchLib, new char[]{'H', 'C', 'F', 'R', 'T', 'O', '#'});
            Cell gallery = scratchLib.findNodeProto("gallery{lay}");
            DRC.DRCPreferences dp = new DRC.DRCPreferences(true);
            dp.ignoreAreaCheck = true;
            dp.ignoreExtensionRuleChecking = true;
            ErrorLogger errorLog = Quick.checkDesignRules(dp, gallery, null, null);
            errorLog.termLogging(true);
            numErrs = errorLog.getNumErrors();
        }
        catch (Exception e) {
            System.out.println("exception: " + e);
            e.printStackTrace();
            return false;
        }
        boolean bl = cleanDRC = numErrs == 0;
        if (!sameLib) {
            System.out.println("ERROR: Library generated is different from the reference");
        } else if (!cleanDRC) {
            System.out.println("ERROR: DRC errors in basicGateGenerationTest");
        }
        return sameLib && cleanDRC;
    }
}

