/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.technology.Layer;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.MutableBoolean;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PolyMerge
extends GeometryHandler
implements Serializable {
    @Override
    public void add(Layer key, Object value) {
        PolyBase poly;
        Layer layer = key;
        if (value instanceof PolyBase) {
            poly = (PolyBase)value;
        } else if (value instanceof Shape) {
            poly = new PolyBase(((Shape)value).getBounds2D());
        } else {
            return;
        }
        this.addPolygon(layer, poly);
    }

    public void addRectangle(Layer layer, Rectangle2D rect) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            area = new Area();
            this.layers.put(layer, area);
        }
        Area additionalArea = new Area(rect);
        area.add(additionalArea);
    }

    public void addPolygon(Layer layer, PolyBase poly) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            area = new Area();
            this.layers.put(layer, area);
        }
        Area additionalArea = new Area(poly);
        area.add(additionalArea);
    }

    @Override
    public void subtract(Object layer, Object poly) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return;
        }
        Area subtractArea = new Area((PolyBase)poly);
        area.subtract(subtractArea);
    }

    @Override
    public void addAll(GeometryHandler subMerge, FixpTransform trans) {
        PolyMerge other = (PolyMerge)subMerge;
        this.addMerge(other, trans);
    }

    public void addMerge(PolyMerge other, FixpTransform trans) {
        for (Layer subLayer : other.layers.keySet()) {
            Area subArea = (Area)other.layers.get(subLayer);
            Area area = (Area)this.layers.get(subLayer);
            if (area == null) {
                area = new Area();
                this.layers.put(subLayer, area);
            }
            Area newArea = subArea.createTransformedArea(trans);
            area.add(newArea);
        }
    }

    public void addLayer(Layer fromLayer, Layer toLayer) {
        Area fromArea = (Area)this.layers.get(fromLayer);
        if (fromArea == null) {
            return;
        }
        Area toArea = (Area)this.layers.get(toLayer);
        if (toArea == null) {
            toArea = new Area(fromArea);
            this.layers.put(toLayer, toArea);
            return;
        }
        toArea.add(fromArea);
    }

    public boolean intersects(Layer layer, PolyBase poly) {
        Area layerArea = (Area)this.layers.get(layer);
        if (layerArea == null) {
            return false;
        }
        FixpRectangle box = poly.getBox();
        if (box != null) {
            return layerArea.intersects(box);
        }
        Area intersectArea = new Area(poly);
        intersectArea.intersect(layerArea);
        return !intersectArea.isEmpty();
    }

    public void intersectLayers(Layer sourceA, Layer sourceB, Layer dest) {
        Area sourceAreaB;
        Area destArea = null;
        Area sourceAreaA = (Area)this.layers.get(sourceA);
        if (sourceAreaA != null && (sourceAreaB = (Area)this.layers.get(sourceB)) != null) {
            destArea = new Area(sourceAreaA);
            destArea.intersect(sourceAreaB);
            if (destArea.isEmpty()) {
                destArea = null;
            }
        }
        if (destArea == null) {
            this.layers.remove(dest);
        } else {
            this.layers.put(dest, destArea);
        }
    }

    public void subtractLayers(Layer sourceA, Layer sourceB, Layer dest) {
        Area sourceAreaB;
        Area destArea = null;
        Area sourceAreaA = (Area)this.layers.get(sourceA);
        if (sourceAreaA != null && (sourceAreaB = (Area)this.layers.get(sourceB)) != null) {
            destArea = new Area(sourceAreaA);
            destArea.subtract(sourceAreaB);
            if (destArea.isEmpty()) {
                destArea = null;
            }
        }
        if (destArea == null) {
            this.layers.remove(dest);
        } else {
            this.layers.put(dest, destArea);
        }
    }

    public void subtractMerge(PolyMerge other) {
        for (Layer subLayer : other.layers.keySet()) {
            Area area = (Area)this.layers.get(subLayer);
            if (area == null) continue;
            Area subArea = (Area)other.layers.get(subLayer);
            area.subtract(subArea);
        }
    }

    public void insetLayer(Layer source, Layer dest, double amount) {
        Area sourceArea = (Area)this.layers.get(source);
        if (sourceArea == null) {
            this.layers.remove(dest);
        } else {
            this.layers.put(dest, sourceArea.clone());
            if (amount == 0.0) {
                return;
            }
            List<PolyBase> orig = PolyMerge.getAreaPoints(sourceArea, source, true);
            for (PolyBase poly : orig) {
                PolyBase.Point[] points = poly.getPoints();
                for (int i = 0; i < points.length; ++i) {
                    PolyBase.Point thisPt;
                    PolyBase.Point lastPt;
                    int last2 = i - 1;
                    if (last2 < 0) {
                        last2 = points.length - 1;
                    }
                    if (DBMath.areEquals(lastPt = points[last2], thisPt = points[i])) continue;
                    int angle = DBMath.figureAngle(lastPt, thisPt);
                    int perpAngle = (angle + 2700) % 3600;
                    double offsetX = DBMath.cos(perpAngle) * amount;
                    double offsetY = DBMath.sin(perpAngle) * amount;
                    PolyBase.Point insetLastPt = PolyBase.fromLambda(lastPt.getX() + offsetX, lastPt.getY() + offsetY);
                    PolyBase.Point insetThisPt = PolyBase.fromLambda(thisPt.getX() + offsetX, thisPt.getY() + offsetY);
                    PolyBase subtractPoly = new PolyBase(lastPt, thisPt, insetThisPt, insetLastPt);
                    this.subtract(dest, subtractPoly);
                }
            }
        }
    }

    public void deleteLayer(Layer layer) {
        this.layers.remove(layer);
    }

    public boolean isEmpty(Layer layer) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return true;
        }
        return area.isEmpty();
    }

    public boolean contains(Layer layer, Rectangle2D rect) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return false;
        }
        if (area.contains(rect)) {
            return true;
        }
        Area rectArea = new Area(rect);
        rectArea.subtract(area);
        if (rectArea.isEmpty()) {
            return true;
        }
        double remainingArea = this.getAreaOfArea(rectArea);
        return DBMath.areEquals(remainingArea, 0.0);
    }

    public boolean contains(Layer layer, PolyBase poly) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return false;
        }
        Area polyArea = new Area(poly);
        polyArea.subtract(area);
        if (polyArea.isEmpty()) {
            return true;
        }
        double remainingArea = this.getAreaOfArea(polyArea);
        return DBMath.areEquals(remainingArea, 0.0);
    }

    public Area exclusive(Layer layer, PolyBase poly) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return null;
        }
        Area polyArea = new Area(poly);
        polyArea.subtract(area);
        return polyArea;
    }

    public boolean arcPolyFits(Layer layer, Point2D headLoc, Point2D tailLoc, double wid, MutableBoolean headExtend, MutableBoolean tailExtend) {
        int ang = 0;
        if (headLoc.getX() != tailLoc.getX() || headLoc.getY() != tailLoc.getY()) {
            ang = GenMath.figureAngle(tailLoc, headLoc);
        }
        double endExtensionHead = headExtend.booleanValue() ? wid / 2.0 : 0.0;
        double endExtensionTail = tailExtend.booleanValue() ? wid / 2.0 : 0.0;
        Poly arcPoly = Poly.makeEndPointPoly(headLoc.distance(tailLoc), wid, ang, headLoc, endExtensionHead, tailLoc, endExtensionTail, Poly.Type.FILLED);
        if (this.contains(layer, arcPoly)) {
            return true;
        }
        if (headExtend.booleanValue() && this.contains(layer, arcPoly = Poly.makeEndPointPoly(headLoc.distance(tailLoc), wid, ang, headLoc, 0.0, tailLoc, endExtensionTail, Poly.Type.FILLED))) {
            headExtend.setValue(false);
            return true;
        }
        if (tailExtend.booleanValue() && this.contains(layer, arcPoly = Poly.makeEndPointPoly(headLoc.distance(tailLoc), wid, ang, headLoc, endExtensionHead, tailLoc, 0.0, Poly.Type.FILLED))) {
            tailExtend.setValue(false);
            return true;
        }
        if (headExtend.booleanValue() && tailExtend.booleanValue() && this.contains(layer, arcPoly = Poly.makeEndPointPoly(headLoc.distance(tailLoc), wid, ang, headLoc, 0.0, tailLoc, 0.0, Poly.Type.FILLED))) {
            headExtend.setValue(false);
            tailExtend.setValue(false);
            return true;
        }
        return false;
    }

    public double getAreaOfLayer(Layer layer) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return 0.0;
        }
        return this.getAreaOfArea(area);
    }

    private double getAreaOfArea(Area area) {
        List<PolyBase> pointList = PolyMerge.getAreaPoints(area, null, true);
        double totalArea = 0.0;
        for (PolyBase p : pointList) {
            totalArea += p.getArea();
        }
        return totalArea;
    }

    public boolean contains(Layer layer, Point2D pt) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return false;
        }
        return area.contains(pt);
    }

    @Override
    public Collection<PolyBase> getObjects(Object layer, boolean modified, boolean simple) {
        return this.getMergedPoints((Layer)layer, simple);
    }

    public List<PolyBase> getMergedPoints(Layer layer, boolean simple) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return null;
        }
        return PolyMerge.getAreaPoints(area, layer, simple);
    }

    public static List<PolyBase> getAreaPoints(Area area, Layer layer, boolean simple) {
        return PolyBase.getPointsInArea(area, layer, simple, true);
    }
}

