/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;

public enum Compression {
    NONE("tar", new String[0]),
    GZIP("tgz", "gz"),
    BZIP2("tbz2", "bz2");

    private final String defaultExtension;
    private final ImmutableList<String> supportedExtensions;

    private Compression(String defaultExtension, String ... additionalSupportedExtensions) {
        this.defaultExtension = defaultExtension;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(Arrays.asList(additionalSupportedExtensions));
        builder.add((Object)defaultExtension);
        this.supportedExtensions = builder.build();
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public List<String> getSupportedExtensions() {
        return this.supportedExtensions;
    }
}

