/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class TopicFragmentFilter
extends AbstractXMLFilter {
    public static final String PARAM_ATTRIBUTES = "attributes";
    private final Deque<DitaClass> classes = new LinkedList<DitaClass>();
    private final Deque<String> topics = new ArrayDeque<String>();
    List<String> attrNames;

    public TopicFragmentFilter() {
        this.attrNames = Collections.singletonList("href");
    }

    public TopicFragmentFilter(String ... attrNames) {
        this.attrNames = Arrays.asList(attrNames);
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.attrNames == null) {
            this.attrNames = Arrays.asList(((String)this.params.get(PARAM_ATTRIBUTES)).split(","));
        }
        this.classes.clear();
        this.topics.clear();
        super.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Attributes res = atts;
        DitaClass cls = DitaClass.getInstance(atts);
        this.classes.addFirst(cls);
        if (Constants.TOPIC_TOPIC.matches(cls)) {
            this.topics.addFirst(atts.getValue("id"));
        } else {
            for (String attrName : this.attrNames) {
                String fragment;
                URI href = URLUtils.toURI(atts.getValue(attrName));
                if (href == null || !this.isLocalDitaReference(atts, attrName) || (fragment = href.getFragment()) == null || !fragment.startsWith(".")) continue;
                href = URLUtils.setFragment(href, this.topics.peekFirst() + fragment.substring(1));
                res = new AttributesImpl(res);
                XMLUtils.addOrSetAttribute((AttributesImpl)res, attrName, href.toString());
            }
        }
        super.startElement(uri, localName, qName, res);
    }

    private boolean isLocalDitaReference(Attributes atts, String attr) {
        switch (attr) {
            case "conref": 
            case "conrefend": {
                return true;
            }
        }
        String format = atts.getValue("format");
        return format == null || format.equals("dita");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        DitaClass cls = this.classes.removeFirst();
        if (Constants.TOPIC_TOPIC.matches(cls)) {
            this.topics.removeFirst();
        }
        super.endElement(uri, localName, qName);
    }
}

