//**************************************************************************************************
//                                        PrcDataVwr.hpp                                           *
//                                       ----------------                                          *
// Description : Provides an interface to a waveform data viewer application. The user can view    *
//               the raw simulation data or envoke this application which plots the data           *
//               graphically.                                                                      *
// Started     : 2020-09-26                                                                        *
// Last Update : 2020-09-30                                                                        *
// Copyright   : (C) 2020-2020 MSWaters                                                            *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef PRCDATAVWR_HPP
#define PRCDATAVWR_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "Config.hpp"
#include "base/PrcBase.hpp"

//**************************************************************************************************

class PrcDataVwr : public PrcBase
{
  private :

    eTypeDatVwr  m_eDataVwr;        // The data viewer application to envoke
    wxFileName   m_ofnNameResults;  // The simulation engine results data file name

    // Functions for formatting the results file for input to the viewer
    bool  bFormatFile ( void );
//  bool  bFormatLine ( wxString & rosLine );
//  bool  bFormatField( wxString & rosField );

  public :

          PrcDataVwr( void );
         ~PrcDataVwr( );

    bool  bSetDataViewer (       eTypeDatVwr eDataVwr    );
    bool  bSetResultsFile( const wxString &  rosFileName );

          eTypeDatVwr     eGetDataVwrType( void ) { return( m_eDataVwr       ); }
    const wxFileName & rofnGetResultsFile( void ) { return( m_ofnNameResults ); }

    virtual  bool  bExec( void );
};

//**************************************************************************************************

#endif // PRCDATAVWR_HPP
