/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.WriteLimitReachedException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.language.translate.Translator;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParsingReader;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.SAXException;

public class Tika {
    private final Detector detector;
    private final Parser parser;
    private final Translator translator;
    private int maxStringLength = 100000;

    public Tika(Detector detector, Parser parser) {
        this.detector = detector;
        this.parser = parser;
        this.translator = TikaConfig.getDefaultConfig().getTranslator();
    }

    public Tika(Detector detector, Parser parser, Translator translator) {
        this.detector = detector;
        this.parser = parser;
        this.translator = translator;
    }

    public Tika(TikaConfig config) {
        this(config.getDetector(), new AutoDetectParser(config), config.getTranslator());
    }

    public Tika() {
        this(TikaConfig.getDefaultConfig());
    }

    public Tika(Detector detector) {
        this(detector, new AutoDetectParser(detector));
    }

    public String detect(InputStream stream2, Metadata metadata) throws IOException {
        if (stream2 == null || stream2.markSupported()) {
            return this.detector.detect(stream2, metadata).toString();
        }
        return this.detector.detect(new BufferedInputStream(stream2), metadata).toString();
    }

    public String detect(InputStream stream2, String name) throws IOException {
        Metadata metadata = new Metadata();
        metadata.set("resourceName", name);
        return this.detect(stream2, metadata);
    }

    public String detect(InputStream stream2) throws IOException {
        return this.detect(stream2, new Metadata());
    }

    public String detect(byte[] prefix, String name) {
        String string;
        block8: {
            TikaInputStream stream2 = TikaInputStream.get(prefix);
            try {
                string = this.detect((InputStream)stream2, name);
                if (stream2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream2 != null) {
                        try {
                            ((InputStream)stream2).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unexpected IOException", e);
                }
            }
            ((InputStream)stream2).close();
        }
        return string;
    }

    public String detect(byte[] prefix) {
        String string;
        block8: {
            TikaInputStream stream2 = TikaInputStream.get(prefix);
            try {
                string = this.detect(stream2);
                if (stream2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream2 != null) {
                        try {
                            ((InputStream)stream2).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unexpected IOException", e);
                }
            }
            ((InputStream)stream2).close();
        }
        return string;
    }

    public String detect(Path path) throws IOException {
        Metadata metadata = new Metadata();
        try (TikaInputStream stream2 = TikaInputStream.get(path, metadata);){
            String string = this.detect((InputStream)stream2, metadata);
            return string;
        }
    }

    public String detect(File file) throws IOException {
        Metadata metadata = new Metadata();
        try (TikaInputStream stream2 = TikaInputStream.get(file, metadata);){
            String string = this.detect((InputStream)stream2, metadata);
            return string;
        }
    }

    public String detect(URL url) throws IOException {
        Metadata metadata = new Metadata();
        try (TikaInputStream stream2 = TikaInputStream.get(url, metadata);){
            String string = this.detect((InputStream)stream2, metadata);
            return string;
        }
    }

    public String detect(String name) {
        try {
            return this.detect((InputStream)null, name);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException", e);
        }
    }

    public String translate(String text2, String sourceLanguage, String targetLanguage) {
        try {
            return this.translator.translate(text2, sourceLanguage, targetLanguage);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error translating data.", e);
        }
    }

    public String translate(String text2, String targetLanguage) {
        try {
            return this.translator.translate(text2, targetLanguage);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error translating data.", e);
        }
    }

    public Reader parse(InputStream stream2, Metadata metadata) throws IOException {
        ParseContext context = new ParseContext();
        context.set(Parser.class, this.parser);
        return new ParsingReader(this.parser, stream2, metadata, context);
    }

    public Reader parse(InputStream stream2) throws IOException {
        return this.parse(stream2, new Metadata());
    }

    public Reader parse(Path path, Metadata metadata) throws IOException {
        TikaInputStream stream2 = TikaInputStream.get(path, metadata);
        return this.parse(stream2, metadata);
    }

    public Reader parse(Path path) throws IOException {
        return this.parse(path, new Metadata());
    }

    public Reader parse(File file, Metadata metadata) throws IOException {
        TikaInputStream stream2 = TikaInputStream.get(file, metadata);
        return this.parse(stream2, metadata);
    }

    public Reader parse(File file) throws IOException {
        return this.parse(file, new Metadata());
    }

    public Reader parse(URL url) throws IOException {
        Metadata metadata = new Metadata();
        TikaInputStream stream2 = TikaInputStream.get(url, metadata);
        return this.parse(stream2, metadata);
    }

    public String parseToString(InputStream stream2, Metadata metadata) throws IOException, TikaException {
        return this.parseToString(stream2, metadata, this.maxStringLength);
    }

    public String parseToString(InputStream stream2, Metadata metadata, int maxLength) throws IOException, TikaException {
        WriteOutContentHandler handler;
        block8: {
            handler = new WriteOutContentHandler(maxLength);
            ParseContext context = new ParseContext();
            context.set(Parser.class, this.parser);
            try (InputStream inputStream = stream2;){
                this.parser.parse(stream2, new BodyContentHandler(handler), metadata, context);
            }
            catch (SAXException e) {
                if (WriteLimitReachedException.isWriteLimitReached(e)) break block8;
                throw new TikaException("Unexpected SAX processing failure", e);
            }
        }
        return handler.toString();
    }

    public String parseToString(InputStream stream2) throws IOException, TikaException {
        return this.parseToString(stream2, new Metadata());
    }

    public String parseToString(Path path) throws IOException, TikaException {
        Metadata metadata = new Metadata();
        TikaInputStream stream2 = TikaInputStream.get(path, metadata);
        return this.parseToString(stream2, metadata);
    }

    public String parseToString(File file) throws IOException, TikaException {
        Metadata metadata = new Metadata();
        TikaInputStream stream2 = TikaInputStream.get(file, metadata);
        return this.parseToString(stream2, metadata);
    }

    public String parseToString(URL url) throws IOException, TikaException {
        Metadata metadata = new Metadata();
        TikaInputStream stream2 = TikaInputStream.get(url, metadata);
        return this.parseToString(stream2, metadata);
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
    }

    public Parser getParser() {
        return this.parser;
    }

    public Detector getDetector() {
        return this.detector;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public String toString() {
        return Tika.getString();
    }

    public static String getString() {
        String version = null;
        try (InputStream stream2 = Tika.class.getResourceAsStream("/META-INF/maven/org.apache.tika/tika-core/pom.properties");){
            if (stream2 != null) {
                Properties properties = new Properties();
                properties.load(stream2);
                version = properties.getProperty("version");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (version != null) {
            return "Apache Tika " + version;
        }
        return "Apache Tika";
    }
}

