/*
 * Decompiled with CFR 0.152.
 */
package mill.resolve;

import mill.moduledefs.Scaladoc;
import scala.Array$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;

@Scaladoc(value="/**\n * Compute the Levenshtein Distance.\n */")
public final class LevenshteinDistance$ {
    public static final LevenshteinDistance$ MODULE$ = new LevenshteinDistance$();

    public int minimum(int i1, int i2, int i3) {
        return package$.MODULE$.min(package$.MODULE$.min(i1, i2), i3);
    }

    @Scaladoc(value="/**\n   * Short Levenshtein distance algorithm, based on\n   *\n   * https://rosettacode.org/wiki/Levenshtein_distance#Scala\n   */")
    public int editDistance(String s1, String s2) {
        int[][] dist = (int[][])Array$.MODULE$.tabulate(s2.length() + 1, s1.length() + 1, (j, i) -> {
            if (j == 0) {
                return i;
            }
            if (i == 0) {
                return j;
            }
            return 0;
        }, ClassTag$.MODULE$.Int());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), s2.length()).foreach$mVc$sp(j -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), s1.length()).foreach$mVc$sp(i -> {
            dist$1[j$1][i] = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s2), j - 1) == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s1), i - 1) ? dist[j - 1][i - 1] : MODULE$.minimum(dist[j - 1][i] + 1, dist[j][i - 1] + 1, dist[j - 1][i - 1] + 1);
        }));
        return dist[s2.length()][s1.length()];
    }

    private LevenshteinDistance$() {
    }
}

