/*
 * Decompiled with CFR 0.152.
 */
package hhapplet;

import hhapplet.ResourceLib;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Language {
    private static Language m_lan = null;
    private int[] m_charorder;
    private boolean m_bEnglish = true;
    private String m_sBiggestChar = null;
    private String[] m_aStopWords;
    private String[] m_aStems;
    private Hashtable m_hUToC = new Hashtable();

    private String getBiggestCh() {
        if (this.m_sBiggestChar == null) {
            if (this.m_charorder == null) {
                this.m_sBiggestChar = String.valueOf('\u00ff');
            } else {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                do {
                    if (this.m_charorder[n3] <= n) continue;
                    n = this.m_charorder[n3];
                    n2 = n3;
                } while (++n3 <= 255);
                this.m_sBiggestChar = String.valueOf((char)n);
            }
        }
        return this.m_sBiggestChar;
    }

    private boolean isStopW(String string) {
        int n;
        Vector vector;
        if (this.m_aStopWords == null && (vector = ResourceLib.getStopWords()) != null) {
            this.m_aStopWords = new String[vector.size()];
            n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.m_aStopWords[n++] = (String)enumeration.nextElement();
            }
        }
        if (this.m_aStopWords != null) {
            int n2 = this.m_aStopWords.length;
            n = 0;
            int n3 = n2 - 1;
            int n4 = 0;
            boolean bl = false;
            String string2 = "";
            while (n <= n3) {
                n4 = n + n3;
                string2 = this.m_aStopWords[n4 >>= 1];
                if (Language.compare(string, string2) > 0) {
                    n = n == n4 ? n4 + 1 : n4;
                    continue;
                }
                if (Language.compare(string, string2) < 0) {
                    n3 = n3 == n4 ? n4 - 1 : n4;
                    continue;
                }
                bl = true;
                break;
            }
            return bl;
        }
        return false;
    }

    private Language() {
        String string = ResourceLib.GetRes("langorder");
        String string2 = ResourceLib.GetRes("English");
        string2 = string2.toLowerCase();
        this.m_bEnglish = string2.compareTo("true") == 0;
        if (string != null && string.length() > 0) {
            this.m_charorder = new int[256];
            int n = 0;
            int n2 = string.indexOf(44, n);
            int n3 = 0;
            while (n2 != -1) {
                String string3 = string.substring(n, n2);
                if (string3 != null) {
                    this.m_charorder[n3] = Integer.parseInt(string3);
                    ++n3;
                }
                n = n2 + 1;
                n2 = string.indexOf(44, n);
            }
        }
        this.m_hUToC.put(new Integer(8364), new Integer(128));
        this.m_hUToC.put(new Integer(8218), new Integer(130));
        this.m_hUToC.put(new Integer(402), new Integer(131));
        this.m_hUToC.put(new Integer(8222), new Integer(132));
        this.m_hUToC.put(new Integer(8230), new Integer(133));
        this.m_hUToC.put(new Integer(8224), new Integer(134));
        this.m_hUToC.put(new Integer(8225), new Integer(135));
        this.m_hUToC.put(new Integer(710), new Integer(136));
        this.m_hUToC.put(new Integer(8240), new Integer(137));
        this.m_hUToC.put(new Integer(352), new Integer(138));
        this.m_hUToC.put(new Integer(8249), new Integer(139));
        this.m_hUToC.put(new Integer(338), new Integer(140));
        this.m_hUToC.put(new Integer(381), new Integer(142));
        this.m_hUToC.put(new Integer(8216), new Integer(145));
        this.m_hUToC.put(new Integer(8217), new Integer(146));
        this.m_hUToC.put(new Integer(8220), new Integer(147));
        this.m_hUToC.put(new Integer(8221), new Integer(148));
        this.m_hUToC.put(new Integer(8226), new Integer(149));
        this.m_hUToC.put(new Integer(8211), new Integer(150));
        this.m_hUToC.put(new Integer(8212), new Integer(151));
        this.m_hUToC.put(new Integer(732), new Integer(152));
        this.m_hUToC.put(new Integer(8482), new Integer(153));
        this.m_hUToC.put(new Integer(353), new Integer(154));
        this.m_hUToC.put(new Integer(8250), new Integer(155));
        this.m_hUToC.put(new Integer(339), new Integer(156));
        this.m_hUToC.put(new Integer(382), new Integer(158));
        this.m_hUToC.put(new Integer(376), new Integer(159));
    }

    public static String getStem(String string) {
        if (m_lan == null) {
            m_lan = new Language();
        }
        return m_lan.getStemString(string);
    }

    private int compareString(String string, String string2) {
        try {
            if (this.m_charorder != null) {
                int n = 0;
                while (n < string.length() && n < string2.length()) {
                    if (this.m_charorder[this.getCharCode(string, n)] < this.m_charorder[this.getCharCode(string2, n)]) {
                        return -1;
                    }
                    if (this.m_charorder[this.getCharCode(string, n)] > this.m_charorder[this.getCharCode(string2, n)]) {
                        return 1;
                    }
                    ++n;
                }
                if (string.length() < string2.length()) {
                    return -1;
                }
                if (string.length() > string2.length()) {
                    return 1;
                }
                return 0;
            }
            String string3 = string.toLowerCase();
            String string4 = string2.toLowerCase();
            return string3.compareTo(string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    private String getStemString(String string) {
        Object object;
        int n;
        Vector vector;
        if (this.m_aStems == null && (vector = ResourceLib.getStems()) != null) {
            this.m_aStems = new String[vector.size()];
            n = 0;
            object = vector.elements();
            while (object.hasMoreElements()) {
                this.m_aStems[n++] = (String)object.nextElement();
            }
        }
        if (this.m_aStems == null) {
            return string;
        }
        int n2 = this.m_aStems.length;
        n = 0;
        object = "";
        String string2 = "";
        string = string.toLowerCase();
        int n3 = 0;
        while (n3 < n2) {
            if (this.m_aStems[n3].length() < string.length() - 1 && (n = string.lastIndexOf(this.m_aStems[n3])) > 0 && (string2 = string.substring(n)).compareTo(this.m_aStems[n3]) == 0) {
                object = string;
                object = n >= 2 && string.charAt(n - 2) == string.charAt(n - 1) ? ((String)object).substring(0, n - 1) : ((String)object).substring(0, n);
                return object;
            }
            ++n3;
        }
        object = string;
        return object;
    }

    public static String getBiggestChar() {
        if (m_lan == null) {
            m_lan = new Language();
        }
        return m_lan.getBiggestCh();
    }

    public static int compare(String string, String string2) {
        if (m_lan == null) {
            m_lan = new Language();
        }
        return m_lan.compareString(string, string2);
    }

    private int getCharCode(String string, int n) {
        int n2 = string.charAt(n);
        if (n2 >= 256) {
            n2 = (Integer)this.m_hUToC.get(new Integer(n2));
        }
        return n2;
    }

    public static boolean isStopWord(String string) {
        if (m_lan == null) {
            m_lan = new Language();
        }
        return m_lan.isStopW(string);
    }
}

