/*
 * Decompiled with CFR 0.152.
 */
package XMLConsumer;

import XMLConsumer.IEntry;
import XMLConsumer.ITocEntryContainer;
import XMLConsumer.TocData;
import hhapplet.BsscFontFixPatch;
import hhapplet.IActionSink;
import hhapplet.ImageCache;
import hhapplet.URLFileHandler;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import treeview.SiblingChildTree;
import treeview.TreeViewImageSet;

public class TocEntry
extends SiblingChildTree
implements IEntry {
    public static final int TOC_BOOK = 1;
    public static final int TOC_ITEM = 2;
    public static final int TOC_CHUNK = 3;
    public static final int TOC_PROJECT = 4;
    public static final int TOC_REMOTEITEM = 5;
    private static final int TOC_INDENT = 16;
    private String m_name;
    private String m_url;
    private String m_ref;
    private int m_nType;
    private int m_nLevel;
    private boolean m_bSelect;
    private boolean m_bHighLight;
    private TocData m_TocData;
    private boolean m_bOpen;
    private int m_nPosOffset;
    private int m_nIndex;
    private ITocEntryContainer m_Container;
    private String m_strTarget;
    private String m_strIcon;
    private Image m_openIcon;
    private Image m_closeIcon;
    private boolean m_bStubFilled;
    public static final int BOOKOPEN = 1;
    public static final int BOOKCLOSE = 2;
    public static final int ITEM = 3;
    public static final int REMOTE = 4;
    public static final int NEWBOOKOPEN = 5;
    public static final int NEWBOOKCLOSE = 6;
    public static final int NEWITEM = 7;
    public static final int NEWREMOTE = 8;
    private static Image m_iconBookClose;
    private static Image m_iconBookOpen;
    private static Image m_iconItem;
    private static Image m_iconRemote;
    private static Image m_iconNewBookClose;
    private static Image m_iconNewBookOpen;
    private static Image m_iconNewItem;
    private static Image m_iconNewRemote;
    private static Color GREEN;
    private static Color m_activeColor;
    private static int m_indent;
    private static Font m_normalFont;
    private static Font m_hoverFont;
    private static Color m_normalColor;
    private static Color m_hoverColor;
    private static boolean m_normalUnderline;
    private static boolean m_hoverUnderline;
    private static ImageObserver m_observer;

    public void setContainer(ITocEntryContainer iTocEntryContainer) {
        this.m_Container = iTocEntryContainer;
    }

    public ITocEntryContainer getContainer() {
        return this.m_Container;
    }

    public static boolean hasImage(Image image) {
        return m_iconBookClose == image || m_iconBookOpen == image || m_iconItem == image || m_iconRemote == image || m_iconNewBookClose == image || m_iconNewBookOpen == image || m_iconNewItem == image || m_iconNewRemote == image;
    }

    public TocEntry getDirectParent() {
        return (TocEntry)this.getParent();
    }

    public void updatePosOffset(int n) {
        this.m_nPosOffset += n;
    }

    public boolean isMainEntry() {
        return true;
    }

    public TocEntry getPrevSibling() {
        return (TocEntry)this.getSiblingLeft();
    }

    public void select(boolean bl) {
        this.m_bSelect = bl;
    }

    public static void setNormalUnderline(boolean bl) {
        m_normalUnderline = bl;
    }

    public static void setActiveColor(Color color) {
        m_activeColor = color;
    }

    public String getName() {
        return this.m_name;
    }

    public void highLight(boolean bl) {
        this.m_bHighLight = bl;
    }

    public static void setIconImage(int n, Image image) {
        switch (n) {
            case 1: {
                m_iconBookOpen = image;
                return;
            }
            case 2: {
                m_iconBookClose = image;
                return;
            }
            case 3: {
                m_iconItem = image;
                return;
            }
            case 4: {
                m_iconRemote = image;
                return;
            }
            case 5: {
                m_iconNewBookOpen = image;
                return;
            }
            case 6: {
                m_iconNewBookClose = image;
                return;
            }
            case 7: {
                m_iconNewItem = image;
                return;
            }
            case 8: {
                m_iconNewRemote = image;
                return;
            }
        }
    }

    private static Image getImage(int n) {
        TreeViewImageSet treeViewImageSet = TreeViewImageSet.getInstance();
        if (treeViewImageSet != null) {
            return treeViewImageSet.getImage(n);
        }
        return null;
    }

    public int getType() {
        return this.m_nType;
    }

    private Image getREmoteItemIcon() {
        if (this.m_closeIcon == null) {
            if (this.m_strIcon != null) {
                String string = this.getIcon(this.m_strIcon, 0);
                if (string != null) {
                    ImageCache imageCache = ImageCache.getInstance();
                    String string2 = this.getFullPath(string);
                    this.m_closeIcon = imageCache.GetImage(string2);
                }
            } else {
                this.m_closeIcon = m_iconRemote != null ? m_iconRemote : TocEntry.getImage(14);
            }
        }
        return this.m_closeIcon;
    }

    public int getPosOffset() {
        return this.m_nPosOffset;
    }

    public void setPosOffset(int n) {
        this.m_nPosOffset = n;
    }

    public int getLevel() {
        return this.m_nLevel;
    }

    public int getWidth(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(m_normalFont);
        int n = fontMetrics.stringWidth(this.m_name + " ");
        Image image = null;
        switch (this.m_nType) {
            case 1: 
            case 3: 
            case 4: {
                if (this.m_bOpen) {
                    image = this.getBookOpenIcon();
                    break;
                }
                image = this.getBookCloseIcon();
                break;
            }
            case 2: {
                image = this.getItemIcon();
                break;
            }
            case 5: {
                image = this.getREmoteItemIcon();
            }
        }
        int n2 = 0;
        if (image != null) {
            n2 = image.getWidth(m_observer) + 1;
        }
        return m_indent * this.m_nLevel + n + 1 + n2;
    }

    public void updateIndex(int n) {
        this.m_nIndex = n;
    }

    public void remove() {
        this.pruneThisSubtree();
    }

    private Image getBookOpenIcon() {
        if (this.m_openIcon == null) {
            if (this.m_strIcon != null) {
                String string = this.getIcon(this.m_strIcon, 1);
                if (string != null) {
                    ImageCache imageCache = ImageCache.getInstance();
                    String string2 = this.getFullPath(string);
                    this.m_closeIcon = imageCache.GetImage(string2);
                }
            } else {
                this.m_openIcon = m_iconBookOpen != null ? m_iconBookOpen : TocEntry.getImage(1);
            }
        }
        return this.m_openIcon;
    }

    private Image getItemIcon() {
        if (this.m_closeIcon == null) {
            if (this.m_strIcon != null) {
                String string = this.getIcon(this.m_strIcon, 0);
                if (string != null) {
                    ImageCache imageCache = ImageCache.getInstance();
                    String string2 = this.getFullPath(string);
                    this.m_closeIcon = imageCache.GetImage(string2);
                }
            } else {
                this.m_closeIcon = m_iconItem != null ? m_iconItem : TocEntry.getImage(8);
            }
        }
        return this.m_closeIcon;
    }

    public int getPrevSpan() {
        TocEntry tocEntry = (TocEntry)this.getSiblingLeft();
        if (tocEntry != null) {
            int n = tocEntry.getIndex();
            return this.m_nIndex - n - 1;
        }
        return -1;
    }

    public void setStubFilled() {
        this.m_bStubFilled = true;
    }

    public void setTarget(String string) {
        this.m_strTarget = string;
    }

    public TocEntry getNextSibling() {
        return (TocEntry)this.getSibling();
    }

    public static void setHoverUnderline(boolean bl) {
        m_hoverUnderline = bl;
    }

    public static void setHoverFont(Font font) {
        if (font.getSize() != m_normalFont.getSize()) {
            m_hoverFont = new Font(font.getFamily(), font.getStyle(), m_normalFont.getSize());
            return;
        }
        m_hoverFont = font;
    }

    public static void setNormalColor(Color color) {
        m_normalColor = color;
    }

    public TocEntry(String string, String string2, String string3, int n, int n2, int n3, TocData tocData) {
        this.m_name = string;
        this.m_url = string2;
        this.m_nIndex = n;
        this.m_nType = n2;
        this.m_nLevel = n3;
        this.m_bHighLight = false;
        this.m_bSelect = false;
        this.m_TocData = tocData;
        this.m_bOpen = false;
        this.m_nPosOffset = 0;
        this.m_Container = null;
        this.m_ref = string3;
        this.m_bStubFilled = false;
    }

    public boolean isStubFilled() {
        return this.m_bStubFilled;
    }

    public boolean isOpen() {
        return this.m_bOpen;
    }

    public TocEntry getFirstChild() {
        return (TocEntry)this.getChild();
    }

    public static void SetObserver(ImageObserver imageObserver) {
        m_observer = imageObserver;
    }

    public void setIcon(String string) {
        this.m_strIcon = string;
    }

    private String getIcon(String string, int n) {
        int n2 = string.indexOf(59);
        while (n-- > 0 && n2 != -1) {
            string = string.substring(n2 + 1);
            n2 = string.indexOf(59);
        }
        if (n < 0) {
            if (n2 != -1) {
                return string.substring(0, n2);
            }
            return string;
        }
        return null;
    }

    public static void setNormalFont(Font font) {
        m_normalFont = font;
    }

    public TocEntry getNextOut() {
        TocEntry tocEntry = this;
        while (tocEntry != null) {
            TocEntry tocEntry2 = tocEntry.getNextSibling();
            if (tocEntry2 != null) {
                return tocEntry2;
            }
            tocEntry = tocEntry.getDirectParent();
        }
        return null;
    }

    private String getFullPath(String string) {
        String string2 = null;
        try {
            URL uRL = URLFileHandler.makeURL(this.m_TocData.getProjURL(), string, null);
            string2 = uRL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return string2;
    }

    static {
        GREEN = new Color(0, 127, 0);
        m_activeColor = Color.gray;
        m_indent = 16;
        m_normalFont = new Font(BsscFontFixPatch.GetFontName(), 0, BsscFontFixPatch.GetFontSize());
        m_hoverFont = new Font(BsscFontFixPatch.GetFontName(), 0, BsscFontFixPatch.GetFontSize());
        m_normalColor = Color.black;
        m_hoverColor = GREEN;
        m_normalUnderline = false;
        m_hoverUnderline = true;
        m_observer = null;
    }

    public boolean isStubEntry() {
        return this.getType() == 3 || this.getType() == 4;
    }

    public int getIndex() {
        return this.m_nIndex;
    }

    public String getRef() {
        return this.m_ref;
    }

    public void toggle() {
        this.m_bOpen = !this.m_bOpen;
    }

    public void action(IActionSink iActionSink) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(this);
        vector.addElement(this.m_url);
        vector.addElement(this.m_ref);
        vector.addElement(this.m_TocData);
        vector.addElement(this.m_strTarget);
        iActionSink.accept(vector);
    }

    public int getNextSpan() {
        TocEntry tocEntry = (TocEntry)this.getSibling();
        if (tocEntry != null) {
            int n = tocEntry.getIndex();
            return n - this.m_nIndex - 1;
        }
        return -1;
    }

    public void display(Graphics graphics, int n, int n2, Color color, Image image) {
        int n3;
        FontMetrics fontMetrics = graphics.getFontMetrics(m_normalFont);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(m_hoverFont);
        int n4 = fontMetrics.stringWidth(this.m_name + " ");
        n4 = n4 > (n3 = fontMetrics2.stringWidth(this.m_name + " ")) ? n4 : n3;
        int n5 = fontMetrics.getAscent();
        int n6 = fontMetrics.getLeading();
        int n7 = fontMetrics2.getAscent();
        int n8 = fontMetrics2.getLeading();
        Image image2 = null;
        switch (this.m_nType) {
            case 1: 
            case 3: 
            case 4: {
                if (this.m_bOpen) {
                    image2 = this.getBookOpenIcon();
                    break;
                }
                image2 = this.getBookCloseIcon();
                break;
            }
            case 2: {
                image2 = this.getItemIcon();
                break;
            }
            case 5: {
                image2 = this.getREmoteItemIcon();
            }
        }
        Color color2 = graphics.getColor();
        Font font = graphics.getFont();
        int n9 = 0;
        if (image2 != null) {
            n9 = image2.getWidth(m_observer) + 1;
        }
        graphics.drawImage(image2, m_indent * this.m_nLevel, n * n2, m_observer);
        if (this.m_bSelect) {
            graphics.setColor(m_activeColor);
            graphics.fill3DRect(m_indent * this.m_nLevel + n9, n * n2, n4, n2, true);
            graphics.setColor(color2);
        } else if (image != null) {
            graphics.drawImage(image, m_indent * this.m_nLevel + n9, n * n2, m_indent * this.m_nLevel + n9 + n4, n * n2 + n2, m_indent * this.m_nLevel + n9, n * n2, m_indent * this.m_nLevel + n9 + n4, n * n2 + n2, null);
        } else {
            graphics.setColor(color);
            graphics.fillRect(m_indent * this.m_nLevel + n9, n * n2, n4, n2);
            graphics.setColor(color2);
        }
        if (this.m_bHighLight) {
            graphics.setFont(m_hoverFont);
            graphics.setColor(m_hoverColor);
            graphics.drawString(this.m_name, m_indent * this.m_nLevel + n9, n * n2 + n7 + n8);
            if (m_hoverUnderline) {
                graphics.drawLine(m_indent * this.m_nLevel + n9, (n + 1) * n2 - 1, m_indent * this.m_nLevel + n4 - 1 + n9, (n + 1) * n2 - 1);
            }
            graphics.setFont(font);
            graphics.setColor(color2);
            return;
        }
        graphics.setFont(m_normalFont);
        graphics.setColor(m_normalColor);
        graphics.drawString(this.m_name, m_indent * this.m_nLevel + n9, n * n2 + n5 + n6);
        if (m_normalUnderline) {
            graphics.drawLine(m_indent * this.m_nLevel + n9, (n + 1) * n2 - 1, m_indent * this.m_nLevel + n4 - 1 + n9, (n + 1) * n2 - 1);
        }
        graphics.setFont(font);
        graphics.setColor(color2);
    }

    public static void setIndent(int n) {
        m_indent = n;
    }

    public static void setHoverColor(Color color) {
        m_hoverColor = color;
    }

    private Image getBookCloseIcon() {
        if (this.m_closeIcon == null) {
            if (this.m_strIcon != null) {
                String string = this.getIcon(this.m_strIcon, 0);
                if (string != null) {
                    ImageCache imageCache = ImageCache.getInstance();
                    String string2 = this.getFullPath(string);
                    this.m_closeIcon = imageCache.GetImage(string2);
                }
            } else {
                this.m_closeIcon = m_iconBookClose != null ? m_iconBookClose : TocEntry.getImage(0);
            }
        }
        return this.m_closeIcon;
    }
}

