#! /bin/sh
# Copyright (C) 2001 Ensim Corporation. All Rights Reserved.
#

# PATH
#
PATH=.:./gnu:$SYSTEMROOT/System32:$PATH
export PATH

# command definitions (OS specific)
#
AWK="awk"
CAT="awk {print}"
LESS="-z16 -y16 -E -F -P Press \<SPACE\> to scroll\. \'q\' to stop viewing this list\."
MORE="less"

export AWK
export CAT
export LESS
export MORE

LINUX=windows
export LINUX

# coordinates
#
KSGENDIR=.
export KSGENDIR

# Utilities
. $KSGENDIR/lib/config
. $KSGENDIR/os.dep

F_display_copyright
F_display_wininfo
echo -n "Press <ENTER> to continue, or ^C to abort."
read _q_anykey
echo "This will prepare a custom RedHat Linux installation floppy ."
F_display_warning

_q_choice="Webppliance"
_q_packages="$KSGENDIR/lib/data/wppackages.dat" 
_q_post_kscreat="post_kscreate_lwp"
_q_product="wpsetup.sh"
_q_xmlparserurl=$_q_wpparserurl
_q_xmlurl=$_q_wpxmlurl
_q_installfileurl=$_q_wpinstallfileurl
_q_installfile=$_q_wpinstallfile

echo ""
echo "   You need to create an OS installation floppy ."
echo "   The floppy generated by this program, will install webppliance "
echo "   after compatible RedHat Linux installation on the target machine."
echo ""
echo -n "Press <ENTER> to continue, or ^C to abort."
read _q_anykey

F_ckyorn "y" "> Do you have a Ensim WEBppliance Pro CD?"
if [ X"$_q_yorn" = X"y" ] ; then
	_q_cdrom="-c"
else
echo "Downloading the lists of http and ftp sites having the RedHat installation tree from Ensim's ftp server ..." 
wget -t 5 -N --passive-ftp -q $_q_ftpdata --directory-prefix=$KSGENDIR/lib/data
wget -t 5 -N --passive-ftp -q $_q_httpdata --directory-prefix=$KSGENDIR/lib/data
	echo ""
fi
  . $KSGENDIR/ksgen.sh

# __END__
