#! /bin/sh
# Copyright (C) 2001 Ensim Corporation. All Rights Reserved.
#

# command definitions (OS specific)
#
AWK="awk"
CAT="awk {print}"
LESS="-z16 -y16 -E -F -P Press \<SPACE\> to scroll\. \'q\' to stop viewing this list\."
MORE="less"

export AWK
export CAT
export LESS
export MORE


echo ""
#    F_Get_wpinstall
    F_read_netconfig
echo ""

echo "  If you have a saved configuration data file that you would like to"
echo "  use, you can bypass the following questions which gather information"
echo "  about your target system."
echo ""

while [ "$_q_config" = "y" ]
do
F_ckyorn "n" "> Do you have a saved configuration data file?"

if [ $_q_yorn = "n" ]
then
    _q_config="n"
    F_read_installsource
#    F_read_lwpsource
    F_read_disk
	F_read_bootloader
    F_read_language
    F_read_keyboard
    F_read_mouse
    F_read_tz
    stty -echo
    F_root_passwd
    F_admin_passwd
    stty echo
#    F_Get_updates
    echo ""	
    F_ckyorn "n" "> Do you want to pass extra options to the kernel at the boot prompt?"
	
    if [ $_q_yorn = "y" ]
    then
	cp -f $KSGENDIR/sysaic7xxx.cfg $KSGENDIR/syslinux.cfg
	if [ $_q_choice = "Webppliance" ]
	then
                _q_packages="$KSGENDIR/lib/data/wpaic7xxxpackages.dat"
	else
                _q_packages="$KSGENDIR/lib/data/cxcaic7xxxpackages.dat"
	fi
    else
	cp -f $KSGENDIR/syslinux.cfg.default $KSGENDIR/syslinux.cfg
    fi

    F_read_email
else
    	_q_config="n"
	echo ""
	echo "Please enter the filename to save the configuration."
	echo "Don't specify the path."
	echo "Example:kickstart"
    	F_checkfile "Filename: "

fi

done

F_handle_ksdump
F_kscreat | gzip | gzip -d - > ./ks.cfg

if [ X"$_q_choice" = X"Webppliance" ]
then

	F_display_license
	F_ckyorn "y" "Do you agree to the terms of the license? [y/n]:"
else 
	_q_yorn="y"
fi	

	if [ $_q_yorn = "y" ]
	then

	echo ""
	echo "The RedHat Installation Floppy Image must be copied to a diskette."
	echo ""

	echo "Please insert a blank diskette in the floppy drive."
	echo -n "Press <ENTER> when you are ready to copy the installation image ... "
	read _q_yorn
	
	cp -rf $_q_bootimage_W $KSGENDIR/boot.img
	
		if [ $? -ne 0 ]
		then 
			echo "*** Error while dumping floppy image.Exiting."
			exit 1
		fi	

	else exit 21
	fi
# __END__
