#! /bin/sh
# Copyright (C) 2002 Ensim Corporation. All Rights Reserved.
#

# PATH
#
PATH=.:/sbin:/bin:/usr/sbin:/usr/bin:/usr/local/sbin:/usr/local/bin:
export PATH

# command definitions
#
AWK=awk
CAT=cat
LINUX=linux

export AWK
export CAT
export LINUX

# coordinates
#
KSGENDIR=`pwd`
export KSGENDIR

# Are we root?
#
#uid=`$AWK '/[Uu][Ii][Dd]/ {print $2}' /proc/self/status`
uid=`id -u`
if [ X"$uid" = X"" ] || [ ! $uid -eq "0" ]
then
    echo "*** You need to be root. Exiting."
    exit 255
fi

# Utlities
#
. $KSGENDIR/os.dep
. $KSGENDIR/lib/config

_q_choice="Webppliance"
_q_packages="$KSGENDIR/lib/data/wppackages.dat" 
_q_post_kscreat="post_kscreate_lwp"
_q_product="wpsetup.sh"
_q_xmlparserurl=$_q_wpparserurl
_q_xmlurl=$_q_wpxmlurl
_q_installfileurl=$_q_wpinstallfileurl
_q_installfile=$_q_wpinstallfile
F_display_copyright
F_display_info
echo -n "Press <ENTER> to continue, or ^C to abort."
read _q_anykey


#F_installer
echo ""
F_ckyorn "y" "> Is this the target server for installing/upgrading Linux Webppliance?"
_q_local=$_q_yorn
echo ""
F_ckyorn "y" "> Do you have a Ensim WEBppliance Pro CD?"
if [ $_q_yorn = "y" ] && [ $_q_local = "y" ]
then
	clear
	F_display_warning_linux
	echo -n "Press <ENTER> to continue, or ^C to abort."
	read _q_anykey
	F_read_email
	mkdir -p /var/log/ensim
	. $KSGENDIR/lib/updatesetup.sh
	. $KSGENDIR/lib/cdsetup.sh
	_q_cdrom="-c"
		
#	sh /var/lib/ensim/cdsetup.sh $OSI_version $OSI_release

	if [ -x /usr/local/bin/ensim-update ]
	then
		/usr/local/bin/ensim-update -e $_q_email -u $_q_cdrom
		if [ $? == 0 ]
		then
			echo "Your system is upgraded successfully..."
			exit 0
		else
			echo "Failure upgrading/installing webppliance..."
			echo ""
   			echo "Kindly refer to the error log mailed to you for details."
			echo ""
			exit 1
		fi
	else
			echo "Failure: Downloading required data from the ftp server ..."
			echo ""
			exit 1
	fi
elif [ X"$_q_yorn" = X"n" ] ; then
	echo "Downloading required data from Ensim's ftp server ..."
	
	mkdir -p /var/lib/ensim
    if ! F_get_file /var/lib/ensim  $OSI_DATA_DIR/ensim-installer.sh ; then
		echo "*** Error initializing setup."
		exit 1
   fi
   if ! F_get_file $KSGENDIR/lib/data  $OSI_DATA_DIR/ftp.dat ; then
		echo "*** Error initializing setup."
		exit 1
   fi
   if ! F_get_file $KSGENDIR/lib/data  $OSI_DATA_DIR/http.dat ; then
		echo "*** Error initializing setup."
		exit 1
   fi
elif [ X"$_q_yorn" = X"y" ] ; then
	_q_cdrom="-c"
fi

_q_yorn=$_q_local
if [ $_q_yorn = "y" ]
then
	clear
	F_display_warning_linux
	echo -n "Press <ENTER> to continue, or ^C to abort."
	read _q_anykey
	F_read_email
	mkdir -p /var/log/ensim
	. $KSGENDIR/lib/updatesetup.sh
	_q_cdrom=""

	if [ -f /var/lib/ensim/ensim-installer.sh ] 
	then
		/usr/local/bin/ensim-update -e $_q_email -u $_q_cdrom
		if [ $? == 0 ]
		then
			echo "Your system is upgraded successfully..."
			exit 0
		else
			echo "Failure upgrading/installing webppliance..."
			echo ""
   			echo "Kindly refer to the error log mailed to you for details."
			echo ""
			exit 1
		fi
	else
			echo "Failure: Downloading required data from the ftp server ..."
			echo ""
			exit 1
	fi
else 
		_q_installer="y"
		echo "You will have to prepare an installation floppy for installing RedHat Linux 7.3 on the target server or run this appliacation on the target server."
		echo -n "Press <ENTER> to continue, or ^C to abort."
		read _q_anykey
		echo ""
		clear
fi	
	 	
if [ X"$_q_installer" == X"y" ]
then
	echo "This will prepare a RedHat Linux installation floppy ."
	F_display_warning

echo ""
echo "   The floppy generated by this program, will install webppliance "
echo "   after compatible RedHat Linux installation on the target machine."
echo ""
echo -n "Press <ENTER> to continue, or ^C to abort."
read _q_anykey
echo ""
clear
. $KSGENDIR/ksgen.sh

fi
# __END__
