#!/bin/sh
mkdir -p /var/lib/ensim
mkdir -p /var/log/ensim
mkdir -p /tmp/downloads
touch /usr/local/bin/ensim-update
chmod 755 /usr/local/bin/ensim-update
    
	#/usr/local/bin/ensim-update generation
	#
awk '{print}' > /usr/local/bin/ensim-update<< WPSETUPGEN_0
#! /bin/sh
# Copyright (C) 2002 Ensim Corporation. All Rights Reserved.
#

get_file()
{
    ncftpget=/usr/bin/ncftpget
	copy=/bin/cp
   	local_dir=\$1
    remote_file=\$2
    status=0
	result=0
	cdrom=\$3

	if [ X"\$cdrom" != X"-c" ] 
	then
		if [ -f \$local_dir/\$remote_file ]; then rm -f \$local_dir/\$remote_file
		fi

		\$ncftpget -u \$FTP_LOGIN -p \$FTP_PASSWD -r 3 -t 60 -VZF \$FTP_SERVER \$local_dir \$OSI_DATA_DIR/\$remote_file
		result=\$?
	elif [ ! -f \$local_dir/\$remote_file ]; then
		status=1	
	fi

		if [ \$result -ne 0 ]; then
		status=1
		fi
		return \$status
}
fail()
{
	echo "*** Failure obtaining the required data ." >> /tmp/updateserr
	echo "###`uname -a`###" >> /tmp/updateserr
	mail -s "\$HOSTNAME[Error]:Initializing Setup ."  \$2 < /tmp/updateserr
}

		export FTP_SERVER=$FTP_SERVER
		export OSI_DIR=$OSI_DIR
		export OSI_version=$OSI_version
		export OSI_release=$OSI_release
		export OSI_DATA_DIR=$OSI_DATA_DIR
		export OSI_RPMS_DIR=$OSI_RPMS_DIR
		export OSI_PUC_DIR=$OSI_PUC_DIR
		export FTP_LOGIN=$FTP_LOGIN
		export FTP_PASSWD=$FTP_PASSWD
		_q_downloaddata="/var/lib/ensim"
	
		if [ X"\$4" != X"-c" ]
		then
			echo "Downloading required data from  ftp server ....."
			if ! get_file \$_q_downloaddata ensim-installer.sh \$4 ; then
				fail
				exit 1
			fi
		else
			sh /var/lib/ensim/cdsetup.sh $OSI_version $OSI_release
		fi
			
		if [ ! -f \$_q_downloaddata/ensim-installer.sh ]; then
				fail
				exit 1
		fi

	echo "$_q_email" > /var/lib/ensim/email
	if [ -f /var/lib/ensim/ensim-installer.sh ]
	then
		sh /var/lib/ensim/ensim-installer.sh \$1 \$2 \$3 \$4 \$5 \$6
		if [ \$? == 0 ]
		then
			echo "Your system is updated successfully..."
			exit 0
		else
			echo ""
   			echo "Kindly refer to the error logs mailed to you for details."
			echo ""
			exit 1
		fi
	else
    	echo "Error connecting/downloading from Ensim's ftp server"
		exit 1
	fi

# __END__
WPSETUPGEN_0
	
