#!/bin/bash
#
# Copyright (c) Ensim Corporation, 2002   All Rights Reserved.
#
# This software is furnished under a license and may be used and copied
# only  in  accordance  with  the  terms  of such  license and with the
# inclusion of the above copyright notice. This software or any other
# copies thereof may not be provided or otherwise made available to any
# other person. No title to and ownership of the software is hereby
# transferred.
#
# The information in this software is subject to change without notice
# and  should  not be  construed  as  a commitment by Ensim Corporation.
# Ensim assumes no responsibility for the use or  reliability  of its
# software on equipment which is not supplied by Ensim.
#
. files/installer.dat
rpm_dir='download'
. files/$strings_lib
. files/installer.lib
. /etc/rc.d/init.d/functions
. $KSGENDIR/lib/config
. files/upgrade-redhat.lib

parse_args "$@"
if [ $? -ne 0 ]; then
	show_usage;
	exit 1
fi

create_logs "$log_dir"
if [ $? -ne 0 ]; then
	echo "$CREATE_LOGS_FAIL"
	exit_handler 1
fi

trap "clean_up; exit" 1 2 3 15;


if  [ $interactive -eq 0 ] && [ -r "$config_file" ]; then
	validate_config "$config_file"
	if [ $? -ne 0 ]; then
		log_errors "$INVALID_CONFIG_FILE"
		echo "$INVALID_CONFIG_FILE"
		exit_handler 1
	else
		. "$config_file"
	fi
fi


#######################################
# Main
#######################################
clear;
check_user;
if [ $? -ne 0 ]; then
	echo "$NOT_ROOT"
	exit_handler 1
fi

if [ "$interactive" -eq 1 ]; then
	cat "$file_path/splash.txt" 2> /dev/null
	if [ $? -ne 0 ]; then
		echo "$INSTALLER_ERROR"
		log_errors "$INSTALLER_INCOMPLETE"
		exit_handler 1
	fi

	usr_resp='y'
	get_user_response 'y' "$CONTINUE_MSG: "
	if [ "$usr_resp" = 'n' ]; then
                exit_handler 1
	fi

	clear
	more -d "$file_path/oem_license.txt"	

	get_user_response 'y' "$LIC_AGREEMENT: "
	if [ "$usr_resp" = 'n' ]; then
		exit_handler 1
	fi
fi

######################################################
#	Save configuration file for unattended install
######################################################
if [ "$interactive" -eq 1 ]; then
       	get_user_response 'y' "$SAVE_CONFIG: "

	if [ "$usr_resp" = 'y' ]; then
		save_install_cfg; 
	fi
fi

#########################################
#       Determine if we are upgrading
#########################################
upgrade=0
if [ -f /usr/lib/opcenter/VERSION ]; then
    lwp_verrel=`cat /usr/lib/opcenter/VERSION`
    lwp_version=`echo $lwp_verrel | cut -f1 -d'-'`
    lwp_release=`echo $lwp_verrel | cut -f2 -d'-'`
    $cmprpm '(none)' $lwp_version $lwp_release '(none)' 3.1.1 31
    agediff=$?
    if   [ $agediff -eq 0 ]; then
	# same version; but check if that's only because we'd already
        # started an upgrade
        if [ -f /tmp/wpupgrade ]; then
            upgrade=1
        fi
	log_actions "$CONTINUING_INSTALL"
    elif [ $agediff -eq 2 ]; then
        # newer version
        log_actions "$STARTING_UPGRADE"
        upgrade=1
        # Leave a marker, in case we have to restart
        touch /tmp/wpupgrade
    elif [ $agediff -eq 1 ]; then
        # older version... huh?
	log_actions "$DISALLOWING_DOWNGRADE"
	exit_handler 1
    fi
fi

#################################################################
#       Run preinstall checks
#################################################################
err_cnt=0
clear
echo "$CHECKING_SYS"
echo_new_line

echo -n "$FIND_HOME"
get_partition;
if [ $? -eq 0 ]; then
	echo_success
	echo
	echo_new_line
else
	echo_failure
	echo
	inc_err;
fi

if [ $upgrade -eq 1 ]; then
    # Make sure the license is present.
    echo -n "$CHECK_LICENSE"
    if [ ! -f /etc/appliance/.license/license.enc ]; then
        echo_failure
        echo
        log_errors "$CHECK_LICENSE_ERROR"
        inc_err;
    else
        echo_success
        echo
    fi
fi
echo -n "$RUNNING_STR check_lang..."
check_lang
if [ $? -eq 0 ]; then
	echo_success
	echo
	log_actions "check_base $OK_STR"
else
	echo_failure
	echo
	echo_new_line
	log_actions "check_base $FAILED_STR"
	exit_handler 6
fi

#Mandatory requirements...
for todo in check_hostname check_net check_diskspace check_shadowpwd ;
do
        echo -n "$RUNNING_STR $todo..."
        $todo
        if [ $? -eq 0 ]; then
		echo_success
		echo
                log_actions "$todo $OK_STR"
        else
		inc_err;
		echo_failure
		echo
                log_actions "$todo $FAILED_STR"
        fi
done
################################################################
#	Baserpms check
################################################################
echo -n "$RUNNING_STR check_os..."
check_os
if [ $? -eq 0 ]; then
	echo_success
	echo
	log_actions "check_base $OK_STR"
else
	echo_failure
	echo
	echo_new_line
	log_actions "check_base $FAILED_STR"
	echo "You have RedHat $_q_rhlrelease installed on this Server . "
	echo "OSI will attempt to upgrade this to RedHat $_q_rhl."
	F_ckyorn "y" "> Do you want to upgrade to RedHat $_q_rhl ?"

	if [ $_q_yorn = "y" ]
	then
		if [ $_q_rhlrelease == 7.1 ]
		then 
			_q_rhl="7.2"
			F_read_upgradesource
			if [ $? == 0 ]
			then
				F_upgrade_redhat
				if [ $? -eq 0 ]; then
					echo_success	
					echo
				else
					echo_failure
					echo
					echo "Please refer to $log_dir/$upgrade_log for more details"
					echo "Please refer to $log_dir/$upgrade_log for more details" >> $log_dir/$err_log
					exit_handler 6
				fi
				echo -n "$RUNNING_STR check_os..."
				check_os
				if [ $? -eq 0 ]; then
					echo_success
					echo
					log_actions "check_base $OK_STR"
				else
					echo_failure
					echo
					echo_new_line
					log_actions "check_base $FAILED_STR"
				fi
		  	fi	
		fi
		if [ $_q_rhlrelease == 7.2 ] 
		then 
			_q_rhl="7.3"
			F_read_upgradesource
			if [ $? == 0 ]
			then
				echo "Upgrading RedHat $_q_rhlrelease to RedHat $_q_rhl ..."
				F_upgrade_redhat
				if [ $? -eq 0 ]; then
					echo_success	
					echo
				else
					echo_failure
					echo
					echo "Please refer to $log_dir/$upgrade_log for more details"
					echo "Please refer to $log_dir/$upgrade_log for more details" >> $log_dir/$err_log
					exit_handler 6
				fi
			fi
		fi
	else 
		_q_installer="y"
		echo_failure
		echo
		echo "Please refer to $log_dir/$upgrade_log for more details"
		echo "Please refer to $log_dir/$upgrade_log for more details" >> $log_dir/$err_log
		exit_handler 6
	fi
fi	

echo -n "$RUNNING_STR check_base..."
missing_rpms=`check_base $file_path/baserpms.list`
if [ $? -eq 0 ]; then
	echo_success
	echo
	log_actions "check_base $OK_STR"
else
	echo_failure
	echo
	echo_new_line
	log_actions "check_base $FAILED_STR"
    echo "$MISSING_RPMS_PROMPT:$missing_rpms "
	exit 1

#	if [ $interactive -eq 1 ]; then
#	        usr_resp='y'
#	        get_user_response 'n' "$MISSING_RPMS_PROMPT: "
#	        if [ "$usr_resp" = 'n' ]; then
# 	              exit_handler 6
#	        fi
#	else
#		exit_handler 6
#	fi
fi
echo -n "$RUNNING_STR check_essential..."
missing_rpms=`check_base $file_path/essential.list`
if [ $? -eq 0 ]; then
	echo_success
	echo
	log_actions "check_essential $OK_STR"
else
	echo_failure
	echo
	echo_new_line
	log_actions "check_essential $FAILED_STR"

    echo "$MISSING_ESSENTIAL_RPMS:$missing_rpms "
	exit 1
fi


#Mandatory requirements...
for todo in check_ncftp check_rpm;
do
        echo -n "$RUNNING_STR $todo..."
        $todo
        if [ $? -eq 0 ]; then
		echo_success
		echo
                log_actions "$todo $OK_STR"
        else
		inc_err;
		echo_failure
		echo
                log_actions "$todo $FAILED_STR"
        fi
done

if [ $err_cnt -ne 0 ]; then
        echo "$REQUIREMENTS_NOT_MET"
	echo "$CHECK_ERR_LOG"
	log_actions "$REQUIREMENTS_NOT_MET"
        exit_handler 6
fi

err_cnt=0
#Optional requirements...
for todo in check_pty check_mem check_swap;
do
        echo -n "$RUNNING_STR $todo..."
        $todo
        if [ $? -eq 0 ]; then
                echo_success
                echo
                log_actions "$todo $OK_STR"
        else
                inc_err;
                echo_failure
                echo
                log_actions "$todo $FAILED_STR"
        fi
done
 
if [ $err_cnt -ne 0 ]; then
        log_actions "$REQUIREMENTS_NOT_MET"

        if [ $interactive -eq 1 ]; then
                get_user_response 'y' "$OPT_REQ_PROMPT: "
                if [ "$usr_resp" = 'n' ]; then
			echo "$CHECK_ERR_LOG"
                        exit_handler 6
		fi	
	else
		exit_handler 6
	fi
fi


# /tmp/wpconflicts is used to allow us to restart partial
# installs. Basically, it is a marker indicating that the
# conflicts check has already been performed, and need
# not be performed again (especially as it might fail, if
# some LWP RPMs have already been installed)
if [ $upgrade -eq 0 -a ! -f /tmp/wpconflicts ]; then
    echo -n "$RUNNING_STR check_conflicts..."
    con_list=`check_conflicts $file_path/conflicts.list`
    ret=$?
    if [ $ret -eq 0 ]; then 
	    echo_success
	    echo
            # marker so that we don't do this again
            touch /tmp/wpconflicts
	    log_actions "check_conflicts $OK_STR"
    elif [ $ret -eq 2 ]; then
	    echo_failure
	    echo
	    log_actions "check_conflicts $FAILED_STR"
	    exit_handler 6
    elif [ $ret -eq 1 ]; then
	    echo_failure
	    echo

	    log_actions "check_base $FAILED_STR"
	    log_errors "$CONFLICTING_RPMS $con_list"

	    if [ $interactive -eq 1 ]; then
		    echo "$CONFLICTING_RPMS $con_list"
		    echo_new_line

		    get_user_response 'y' "$CONFLICTING_RPMS_PROMPT: "
		    if [ "$usr_resp" = 'n' ]; then
			    echo "$CONFLICTS_WARNING"
			    exit_handler 6
		    else
			    bad_exit=0
			    echo -n "$UNINSTALL_RPM"
			    rpm_output=`rpm -e $con_list 2>&1`
			    if [ $? -eq 0 ]; then
				    echo_success
				    echo
			    else
				    echo_failure
				    echo
				    echo "$UNINSTALL_FAIL"
				    log_errors "$rpm_output"
				    echo "$CHECK_ERR_LOG"
				    exit_handler 6
			    fi
		    fi
	    else
		    echo "$UNINSTALL_FAIL"
		    echo "$CHECK_ERR_LOG"
		    exit_handler 6
	    fi
    fi
fi

###################################################
# Horrible, painful check for rpm > 4.0.4-7x.18,
# due to nasty bug in previous versions of rpm
###################################################

if [ $upgrade -eq 1 ]; then
    echo -n "$RH73_RPM_CHECK"
    evr=`rpm -q --queryformat '[%{epoch} %{version} %{release}]\n' rpm`
    $cmprpm $evr "(none)" 4.0.4 7x.18
    agediff=$?
    if [ $agediff -eq 2 ]; then
        echo_failure
        echo
        echo "$RPM_IS_TOO_OLD"
        log_errors "$RPM_IS_TOO_OLD"
        exit_handler 9
    else
        echo_success
        echo
    fi
fi


exit_handler 0
