#!/bin/sh
# Copyright (C) 2002 Ensim Corporation. All Rights Reserved.
#
mkdir -p /var/lib/ensim
mkdir -p /tmp/oem/apt/ensim
touch /var/lib/ensim/aptcd
touch /var/lib/ensim/cdsetup.sh
chmod 755 /var/lib/ensim/cdsetup.sh

awk '{print}' > /var/lib/ensim/aptcd << WPSETUPGEN_0
#! /bin/sh
# Copyright (C) 2002 Ensim Corporation. All Rights Reserved.
#
	apt-cdrom --no-act add >apt.out.$$ 2>&1 << EOF

Linux WEBppliance Pro
EOF
	ret=\$?
	if [ "\$ret" -eq 0 ]; then
		exit 0
	else 
		exit 1
	fi

# __END__
WPSETUPGEN_0

awk '{print}' > /var/lib/ensim/cdsetup.sh << WPSETUPGEN_0
#! /bin/sh
# Copyright (C) 2002 Ensim Corporation. All Rights Reserved.
#
_q_updateslog=/var/log/ensim/updates.log
_q_updateserr=/var/log/ensim/updates.err
touch \$_q_updateslog
touch \$_q_updateserr
OSI_version=\$1
OSI_release=\$2
F_read_CD()
{
#	sh /var/lib/ensim/aptcd
#	ret=\$?
#	apt_output=`cat apt.out.\$$ 2> /dev/null`
#	rm -f "apt.out.\$$"
#	if [ "\$ret" -eq 0 ]; then
#			echo "Success adding the disc to the repository." >> \$_q_updateslog
#	else 
#		echo "\$apt_output" >> \$_q_updateserr
#		echo "FAILURE reading/mounting the CDROM." >> \$_q_updateslog
#		return 1
#	fi
	
	echo "copying the rpms from the disc ..."
	/bin/mount /mnt/cdrom 2>>/dev/null
	if [ \$? == 0 ]
	then
		if [ -d /mnt/cdrom/OSI/\$OSI_version/\$OSI_release ]
		then
			cp -rf /mnt/cdrom/OSI /tmp/oem/apt/ensim/
			cp -rf /mnt/cdrom/OSI/\$OSI_version/\$OSI_release/data/ensim-installer.sh /var/lib/ensim/ensim-installer.sh
			if [ -d /tmp/oem/apt/ensim/LWP ] ; then rm -rf /tmp/oem/apt/ensim/LWP ; fi
			mv -f /tmp/oem/apt/ensim/OSI/\$OSI_version/\$OSI_release/LWP /tmp/oem/apt/ensim
			echo "$SUCCESS copying the rpms from the disc." >> \$_q_updateslog
			/bin/umount /mnt/cdrom 2>>/dev/null
			return 0
		else
			echo "FAILURE copying the rpms from the disc." >> \$_q_updateserr
			echo "Please ensure you have the correct CD." >> \$_q_updateserr
			echo "FAILURE copying the rpms from the disc." >> \$_q_updateslog
			echo "Please ensure you have the correct CD."
			/bin/umount /mnt/cdrom 2>>/dev/null
			return 1
		fi
	else
			echo "FAILURE mounting the CD-ROM." >> \$_q_updateserr
			echo "FAILURE mounting the CD-ROM." >> \$_q_updateslog
			return 1	
	fi
}
err_cnt=0
while [ \$err_cnt -lt 2 ];do 
	echo ""
	echo "Please insert the Ensim WEBppliance Pro CD in the CD-ROM drive"
	eject
	echo -n "Press <ENTER> to continue, or ^C to abort."
	read _q_anykey
	echo ""
	F_read_CD
		if [ \$? = 0 ] 
		then
			echo "Successfully added the Disc to the Repository" 
			err_cnt=2
		else
			echo "Error reading from disc."
			let err_cnt=err_cnt+1
			echo ""
			if [ \$err_cnt == 2 ] 
			then
					echo "Please ensure you have the correct CD."
					exit 1
			fi
		fi
done
# __END__
WPSETUPGEN_0
