#! /bin/sh
# Copyright (C) 2002 Ensim Corporation. All Rights Reserved.
#


echo ""
	F_read_netconfig
echo ""
echo "  If you have a saved configuration data file that you would like to"
echo "  use, you can bypass the following questions which gather information"
echo "  about your target system."
echo ""

while [ "$_q_config" = "y" ]
do	
F_ckyorn "n" "> Do you have a saved configuration data file?"
if [ $_q_yorn = "n" ]
then
	_q_config="n"
	F_read_installsource 
#	F_read_lwpsource 
	F_read_disk
	F_read_bootloader
	F_read_language
	F_read_keyboard
	F_read_mouse
	F_read_tz
	stty -echo
	F_root_passwd
	F_admin_passwd
	stty echo

	echo ""
	F_ckyorn "n" "> Do you want to pass extra options to the kernel at the boot prompt?"
	
    if [ $_q_yorn = "y" ]
    then
	cp -f $KSGENDIR/sysaic7xxx.cfg $KSGENDIR/syslinux.cfg
	if [ $_q_choice = "Webppliance" ]
	then
                _q_packages="$KSGENDIR/lib/data/wpaic7xxxpackages.dat"
	else
                _q_packages="$KSGENDIR/lib/data/cxcaic7xxxpackages.dat"
	fi
    else
	# syslinux.cfg.default will always have prompt 0.
	cp -f $KSGENDIR/syslinux.cfg.default $KSGENDIR/syslinux.cfg
    fi
	F_read_email
else
	_q_config="n"
	echo ""
        echo "Please enter the file pathname of the saved configuration file."
	echo "Kindly specify absolute path for the file."
	echo "Example:/tmp/kickstart"
        F_checkfile "File pathname : "
fi
done
F_handle_ksdump
F_kscreat > /tmp/ks.cfg.$$

if [ X"$_q_choice" = X"Webppliance" ]
then

	F_display_license
	F_ckyorn "y" "Do you agree to the terms of the license? [y/n]:"
else 
	_q_yorn="y"
fi	

if [ $_q_yorn = "y" ]
then
	echo ""
	echo "You have the following options now: "
	echo ""
	echo "  [1] Copy the RedHat Installation Floppy Image to a diskette."
	echo "  [2] Save the RedHat Installation Floppy Image to a file."
	echo ""

_q_done_floppy="n"
while [ $_q_done_floppy = "n" ]
do
    echo -n "Please enter the number corresponding to your choice: "
    read _q_whichopt
    _q_whichopt=`echo $_q_whichopt | $AWK '/^[0-9]+$/ {print}'`
    case X"$_q_whichopt" in
    X"1")
        _q_done_floppy="y"
            mv /tmp/ks.cfg.$$ $KSGENDIR/ks.cfg
        
        . $KSGENDIR/createimage
	;;

    X"2")
        _q_done_floppy="y"
            mv /tmp/ks.cfg.$$ $KSGENDIR/ks.cfg
        F_check_fs loop /proc/devices
        if [ $? -ne 0 ] # loop filesystem not supported
        then
            echo "*** Loopback filesystem not supported. Exiting ..."
            exit 1
        fi
        F_check_fs vfat /proc/filesystems
        if [ $? -ne 0 ] # vfat filesystem not supported
        then
            echo "*** VFAT filesystem not supported. Exiting ..."
            exit 1
        fi
        . ./imgen.sh
        ;;

     X*)
        ;;
esac
done

	echo ""
	echo "Please refer to the README or the documentation for further instructions."
	echo -n "Press <ENTER> to finish."
	read _q_anykey

else 
	echo ""
	echo "Please refer to the README or the documentation for further instructions."
	echo -n "Press <ENTER> to finish."
	read _q_anykey
fi
# __END__
