#! /bin/sh
# Copyright (C) 2002 Ensim Corporation. All Rights Reserved.
#

_q_done="n"
_q_yorn="n"

echo ""
echo "  [Creating RedHat Installation Floppy Image]"
echo ""
echo "Please enter the file pathname to save the floppy image."
echo "Kindly specify absolute path for the file."
echo "Example:/tmp/ks.img"
F_ckfile "File pathname: "
_q_fdimage="$_q_file"

# Unixy stuff
#
cp "$_q_bootimage" $_q_fdimage
if [ $? -ne 0 ]
then
    echo "*** Cannot copy floppy image to $_q_fdimage. Exiting."
    exit 1
fi
mkdir /tmp/ensim_mntpoint.$$
mount -t vfat -o loop $_q_fdimage /tmp/ensim_mntpoint.$$
if [ $? -ne 0 ]
then
    rmdir /tmp/ensim_mntpoint.$$
    echo "*** Failed to mount floppy image. Exiting."
    exit 1
fi
cp -rf $KSGENDIR/ks.cfg /tmp/ensim_mntpoint.$$/
cp -rf $KSGENDIR/syslinux.cfg /tmp/ensim_mntpoint.$$/
umount /tmp/ensim_mntpoint.$$
rmdir /tmp/ensim_mntpoint.$$

echo "  Floppy Image successfully created as: $_q_fdimage"

# __END__
