<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:output method="xml" indent="yes"/>

  <xsl:template match="*">
    <xsl:copy>
      <xsl:apply-templates select="./@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="@*">
    <xsl:copy/>
  </xsl:template>

  <xsl:template match="commonOption[@name='url_net']">
  <option name="url_net" upgrade="0" reconfigure="1" localize="1">
    <title>Domain/subdomain/custom</title>
    <helpmsg>Select a domain or subdomain name that you want to use to access <xsl:value-of select="normalize-space(../longname)"/>.  Alternatively, you may select "Choose a user's web site..." in order to install this <xsl:value-of select="normalize-space(../longname)"/> in a user's home directory. For advanced users, if you would rather enter a path which is exposed via your Web server, select "Choose your own installation directory location..." and enter the full path from /var/www/ in the field below.</helpmsg>
    <ExclusiveSelect>
      <value>
        <internalValue>/home</internalValue>
	<externalValue>Choose a user's web site...</externalValue>
      </value>
      <value>
        <internalValue>/var/www</internalValue>
	<externalValue>Choose your own installation directory location...</externalValue>
      </value>
    </ExclusiveSelect>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='url_net_required']">
  <option name="url_net" upgrade="0" reconfigure="1" localize="1">
    <title>Domain/subdomain</title>
    <helpmsg>Select a domain or subdomain name that you want to use to access <xsl:value-of select="normalize-space(../longname)"/>.  Alternatively, you may select "Choose a user's web site..." in order to install this <xsl:value-of select="normalize-space(../longname)"/> in a user's home directory.</helpmsg>
    <ExclusiveSelect>
      <value>
        <internalValue>/home</internalValue>
	<externalValue>Choose a user's web site...</externalValue>
      </value>
    </ExclusiveSelect>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='static_info']">
    <option name="static_info" inschema="1" insummary="1" reconfigure="0" localize="0">
	  <title>Info</title>
      <SingleInput>
        <default><xsl:value-of select="@info"/></default>
      </SingleInput>
    </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='url_path']">
  <option name="url_path" upgrade="0" reconfigure="1" localize="0">
  	<xsl:attribute name="required">
	  <xsl:value-of select="@required"/>
	</xsl:attribute>
    <title>URL path</title>
    <helpmsg>Enter the url path of the virtual directory you want to use for <xsl:value-of select="normalize-space(../longname)"/>, for example "<xsl:value-of select="normalize-space(../shortname)"/>".</helpmsg>
    <SingleInput>
      <default><xsl:value-of select="normalize-space(../shortname)"/></default>
    </SingleInput>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='url_path_required']">
  <option name="url_path" upgrade="0" reconfigure="1" localize="0">
	<xsl:attribute name="required">
	  <xsl:value-of select="@required"/>
	</xsl:attribute>
    <title>URL path</title>
    <helpmsg>Enter the url path of the virtual directory you want to use for <xsl:value-of select="normalize-space(../longname)"/>, for example "<xsl:value-of select="normalize-space(../shortname)"/>".</helpmsg>
    <SingleInput>
      <default><xsl:value-of select="normalize-space(../shortname)"/></default>
    </SingleInput>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='url_loc']">
  <option name="url_loc" inschema="1" insummary="1" hidden="1" upgrade="0" localize="0">
    <title>URL location</title>
    <SingleInput/>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='install_loc']">
  <option name="install_loc" inschema="1" insummary="1" hidden="1" upgrade="0" localize="0">
    <title>Install location</title>
    <SingleInput/>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='domain_to_path']">
  <option name="domain_to_path" hidden="1" upgrade="0" localize="0">
    <title>Domain to path mapping</title>
    <ExclusiveSelect>
      <value>
        <internalValue>/var/www</internalValue>
      </value>
      <value>
        <internalValue>/home</internalValue>
      </value>
    </ExclusiveSelect>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='dbname']">
  <option name="dbname" inschema="1" insummary="1" upgrade="0" localize="0">
  	<xsl:attribute name="required">
	  <xsl:value-of select="@required"/>
	</xsl:attribute>
    <title>Database name</title>
    <helpmsg>The name of the database where <xsl:value-of select="normalize-space(../longname)"/> will keep its data.  This database will be automatically created at installation time.</helpmsg>
    <SingleInput>
      <default><xsl:value-of select="normalize-space(../shortname)"/></default>
    </SingleInput>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='dbpass']">
  <option name="dbpass" parent="dbname" upgrade="0" localize="0">
  	<xsl:attribute name="required">
	  <xsl:value-of select="@required"/>
	</xsl:attribute>
    <title>Site administrator MySQL password</title>
    <helpmsg>Enter the MySQL password of your site.  If you have not done so already, set this password by clicking the "Change Password" shortcut under MySQL on the home page.</helpmsg>
    <SingleInput password="1" />
  </option>
  </xsl:template>

 <xsl:template match="commonOption[@name='sqldbuser']">
  <option name="sqldbuser" inschema="1" insummary="1" upgrade="0" localize="0">
  	<xsl:attribute name="required">
	  <xsl:value-of select="@required"/>
	</xsl:attribute>
    <title>DataBase User Name </title>
    <helpmsg>Enter the DataBase User Name.</helpmsg>
    <summaryTitle>SQL User</summaryTitle>
   <SingleInput/>
  </option>
  </xsl:template>
  
<xsl:template match="commonOption[@name='sqldbpass']">
  <option name="sqldbpass" parent="sqldbuser" upgrade="0" localize="0">
  	<xsl:attribute name="required">
	  <xsl:value-of select="@required"/>
	</xsl:attribute>
    <title>DataBase User Password</title>
    <helpmsg>Enter the DataBase User Password.</helpmsg>
    <SingleInput password="1" />
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='username']">
  <option name="username" inschema="1" insummary="1" upgrade="0" localize="0">
  	<xsl:attribute name="required">
	  <xsl:value-of select="@required"/>
	</xsl:attribute>
    <title>Tool owner</title>
    <helpmsg>Select the user who will own and be able to edit files installed as part of this tool.  Tool owners rarely need to edit the tool files.</helpmsg>
    <summaryTitle>User</summaryTitle>
    <ExclusiveSelect/>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='syncfs']">
  <option name="syncfs" install="0" upgrade="0" localize="0">
    <title>Recover missing tool files</title>
    <helpmsg>This option will synchronize the existing installation with the original source files.</helpmsg>
    <Boolean/>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='overwritefiles']">
  <option name="overwritefiles" parent="syncfs" install="0" upgrade="0" localize="0">
    <title>Overwrite existing files</title>
    <helpmsg>If selected, this option will cause existing files to be overwritten; if not selected, existing files will not be replaced.</helpmsg>
    <Boolean/>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='archive_name']">
  <option name="archive_name" hidden="1" inschema="1" readonly="1" localize="0">
    <title>Archive name</title>
    <SingleInput>
      <default><xsl:value-of select="@file"/></default>
    </SingleInput>
  </option>
  </xsl:template>  

  <xsl:template match="commonOption[@name='archive_target']">
  <option name="archive_target" hidden="1" inschema="1" readonly="1" localize="0">
    <title>Archive target</title>
    <SingleInput>
      <default><xsl:value-of select="@dir"/></default>
    </SingleInput>
  </option>
  </xsl:template> 

  <xsl:template match="commonOption[@name='archive_type']">
  <option name="archive_type" hidden="1" inschema="1" readonly="1" localize="0">
    <title>Archive type</title>
    <SingleInput>
      <default><xsl:value-of select="@type"/></default>
    </SingleInput>
  </option>
  </xsl:template>  

  <xsl:template match="commonOption[@name='license']">
  <option name="license" reconfigure="0" readonly="1" localize="0">
    <title><xsl:value-of select="normalize-space(../longname)"/> License Agreement</title>
    <MultiInput>
      <currentValue>
      <xsl:value-of select="."/>
      </currentValue>
    </MultiInput>
  </option>
  </xsl:template>  

  <xsl:template match="commonOption[@name='accept_lic']">
  <option name="accept_lic" parent="license" reconfigure="0" localize="1">
    <title>Do you accept this license?</title>
    <helpmsg>You must accept this license agreement in order to install or upgrade this software.</helpmsg>
    <ExclusiveSelect>
      <value>
        <internalValue>1</internalValue>
        <externalValue>Yes, I accept the terms and conditions of this license.</externalValue>
      </value>
      <value default="1">
        <internalValue>0</internalValue>
        <externalValue>No.</externalValue>
      </value>
    </ExclusiveSelect>
  </option>
  </xsl:template>  

  <xsl:template match="commonOption[@name='instance_admin']">
  <option name="instance_admin" reconfigure="0" upgrade="0" localize="0">
  	<xsl:attribute name="required">
	  <xsl:value-of select="@required"/>
	</xsl:attribute>
    <title>Username of tool administrator</title>
    <helpmsg>Enter the username the owner will use to log into the administrative portion of <xsl:value-of select="../longname"/>.</helpmsg>
    <SingleInput>
      <default>admin</default>
    </SingleInput>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='instance_admin_name']">
  <option name="instance_admin_name" reconfigure="0" upgrade="0" localize="0">
    <title>Full name of tool administrator</title>
    <helpmsg>Enter the full name of the administrative user for this tool.</helpmsg>
    <SingleInput>
      <default>Admin</default>
    </SingleInput>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='instance_pass1']">
  <option name="instance_pass1" reconfigure="0" upgrade="0" localize="0">
  	<xsl:attribute name="required">
	  <xsl:value-of select="@required"/>
	</xsl:attribute>
    <title>Password of tool administrator</title>
    <helpmsg>Set the password the owner will use to log into the administrative portion of <xsl:value-of select="../longname"/>.</helpmsg>
    <SingleInput password="1"/>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='instance_pass2']">
  <option name="instance_pass2" reconfigure="0" upgrade="0" localize="0">
  	<xsl:attribute name="required">
	  <xsl:value-of select="@required"/>
	</xsl:attribute>
    <title>Confirm password of tool administrator</title>
    <SingleInput password="1"/>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='instance_admin_email']">
  <option name="instance_admin_email" reconfigure="0" upgrade="0" localize="0">
    <title>Email of tool administrator</title>
    <helpmsg>Set the email address that is required by <xsl:value-of select="../longname"/>.  The tool uses this address for alerts and information.</helpmsg>
    <SingleInput/>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='applypatches']">
  <option name="applypatches" install="0" upgrade="0" localize="0" hidden="1" readonly="1">
    <title>Apply available patches</title>
    <helpmsg>If selected, this option will cause any available patches to be applied.</helpmsg>
    <Boolean/>
  </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='do_backup']">
    <option name="do_backup" install="0" upgrade="1" hidden="0" readonly="0">
      <title>Backup existing data</title>
      <helpmsg>If selected, the upgrade process will first attempt to backup the data indicated.</helpmsg>
      <Boolean/>
    </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='backup_loc']">
    <option name="backup_loc" parent="do_backup" install="0" upgrade="1" hidden="0" readonly="0" localize="0">
      <title>Backup location and file prefix</title>
      <helpmsg>Please specify an absolute path to a location where the backup files should be deposited. The path should end with a filename prefix, which will be used to generate the names of the backup files. For example, if you enter /tmp/backup in this field, then the backup process may create files like /tmp/backup_files.tgz and /tmp/backup_db.tgz. Note that these files must be removed manually.</helpmsg>
      <SingleInput/>
    </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='backup_files']">
    <option name="backup_files" parent="do_backup" install="0" upgrade="1" hidden="0" readonly="0">
      <title>Backup existing files</title>
      <helpmsg>If selected, the upgrade process will first attempt to backup the files present in the tool's installation directory.</helpmsg>
      <Boolean/>
    </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='backup_db']">
    <option name="backup_db" parent="do_backup" install="0" upgrade="1" hidden="0" readonly="0">
      <title>Backup existing database</title>
      <helpmsg>If selected, the upgrade process will first attempt to backup the tool's database.</helpmsg>
      <Boolean/>
    </option>
  </xsl:template>

  <xsl:template match="commonOption[@name='backup_dbpass']">
    <option name="backup_dbpass" parent="backup_db" install="0" upgrade="1" hidden="0" readonly="0" localize="0">
      <title>Site administrator MySQL password.</title>
      <helpmsg>If you choose to backup the tool's database, you must specify the MySQL password so that the database may be accessed.</helpmsg>
      <SingleInput password="1"/>
    </option>
  </xsl:template>
  
</xsl:stylesheet>
