//Include the following namespaces to implement you powertool.
//------------------------------------------------------------
using System;
using System.Collections;
using System.Collections.Specialized;
using Ensim.WVH;
using Ensim.Services.PowerTools;
using EnsimBackendLib;
//------------------------------------------------------------
//Custom Powertool main class must be in the namespace "Ensim.Services.PowerTools"
namespace Ensim.Services.PowerTools {
//Powertool class name must be the same as the shortname specified in the dsp.xml.
//Also this class must inherit from "Powertool" class and must implement the "IDAPIInterface"interface.
public class mypowertool : PowerTool, IDAPIInterface{
//Constructor's must have same declaration as below.
//------------------------------------------
public mypowertool(SiteInfo site, PowerToolXMLData data) :
base(site, data) {
//Custom code goes here
}
public mypowertool(SiteInfo site, PowerToolXMLData data,
IDictionary instanceData) : base(site, data, instanceData) {
//Custom code goes here
}
//------------------------------------------
/// <summary>
/// Method declaration is mandatory. Implement method to install Powertool instance.
/// </summary>
public void Install() {
//Use code below to install a powertool instance
//Use code below if powertool uses any database
/*instanceData.Add("dbuser", dbuser);*/
//Create actions collection
/*ActionCollection actions = new ActionCollection();*/
//Use code below to create msde database
/*actions += new CreateMSDEDB();*/
//Use code below to create mysql database
/*actions += new CreateDB();*/
//Use code below to unpack the archive (zip file). this is the same zip filed created in the
//Power Tool api guide. It contains the Power Tool files.
/*actions += new UnpackArchive();*/
//Use the code below, if powertool needs to set any file permissions on the powertool install location.
/*PermissionsInfo[] pi = new PermissionsInfo[1];
pi[0] = new PermissionsInfo(this.anonUser, AccessMask.Write |AccessMask.Read | AccessMask.Modify);
actions += new
SetPermission(instanceData["install_loc"].ToString(), pi,
PermissionActionType.ADD, true);*/
//Use the code below to create a webdir for the powertool at the install location
/*actions += new
CreateWebDir(instanceData["url_path"].ToString(), true );*/
//Use the code below to move any files between two locations.
//First argument is source and second is destination
/*actions += new
MoveFile(instanceData["install_loc"].ToString() + "\\release.config",
instanceData["install_loc"].ToString() + "\\web.config");*/
//Use the code below to replace key-value pairs in any file.
//Note: file must contain key value pairs, for example web.config file.
/*string origKey, newKey;
Hashtable ht = new Hashtable();
origKey = "<add
key=\"SiteSqlServer\"value=\"Server=(local);Database=mypowertool;uid=
;pwd=;\" />";
newKey = "<add
key=\"SiteSqlServer\"value=\"Server=(local);Database="+
instanceData["dbname"]+";uid="+
instanceData["sqldbuser"]+";pwd="+instanceData["sqldbpass"]+";\" />";
ht.Add(origKey, newKey);
actions += new UpdateFileContent("Web.Config", ht);*/
//Use the code below, if powertool needs to set any iis meta properties.
//For example, if the tool needs to add default.aspx to the "defaultdoc" metapropoerty
/*Hashtable appendProperties = new Hashtable();
appendProperties.Add("DefaultDoc", ",default.htm");
actions += new
SetDefaultProperties(instanceData["url_path"].ToString(),appendProperties, null);*/
//Use the code below to remove any files not required after instance is created
//Pass comma-separated values, values ending with \ are directories and rest are files.
/*actions += new RemoveFiles(@"Installer\",
@"App_GlobalResources\Locales.Portal.xml.resources",
@"App_GlobalResources\Locales.xml.resources");*/
//Use code below to execute all above actions
/*ExecuteActions(actions, ActionType.INSTALL, true);*/
}
/// <summary>
/// When the site admin users password changes, then the ChangePassword method is implemented to handle
/// this password change in the custom Powertool
/// </summary>
/// <param name="username">username whose password has changed.</param>
/// <param name="newpassword">the new password</param>
public void ChangePassword(string username,string newpassword)
{
}
/// <summary>
/// Implement this method if you Custom Powertool requires any reconfiguration.
/// </summary>
public void Reconfigure() {
}
/// <summary>
/// Implement this method if you Custom Powertool implemnts upgrade.
/// This is currently not being used. This method will be used in future releases.
/// </summary>
public void Upgrade() {
}
/// <summary>
/// Method declaration is mandatory. Implement method to remove Powertool instance./// </summary>
public void Remove() {
//use code below to remove the custom powertool instance
/*ActionCollection actions = new ActionCollection();
actions += new RemoveWebDir( instanceData["url_path"] );
actions += new RemoveToolFiles();*/
//Use code below if tool uses msde database.
/*actions += new RemoveMSDEDB();*/
//Use code below if tool uses mysql database.
/*actions += new RemoveDB();*/
//Use code below to execute all above actions
/*ExecuteActions(actions, ActionType.REMOVE, false);*/
}
/// <summary>
/// This methods is used to get the Configuration values for the Custom Powertool.
/// </summary>
/// <returns>Returns an IDictionary object which contains a key-value pair of the custom powertools
/// configuration. These configuration keys are the same as the one's defined in the dsp.xml
/// </returns>
public IDictionary GetInstanceConfiguration() {
/*For Example, if method needs to return configuration
values for keys "dbname", "sqldbuser", "sqldbpass", "username" then
use the commented code below.*/
//IDictionary instance_conf = this.DSPFillInstance(new
// string[] {"dbname", "sqldbuser", "sqldbpass", "username"} );
//return instance_conf;
}
/// <summary>
/// Implement this method if Powertool supports Export/import functionality.
/// Declaration of this method is mandatory.
/// </summary>
/// <param name="datafolderpath">Powertool export location.</param>
public void Export(string datafolderpath) {
/*For example, if powertool uses MSDE databases, then use
the commented code below.*/
//ActionCollection actions = new ActionCollection();
//actions += new ExportMSDEDB(datafolderpath );
//ExecuteActions(actions, ActionType.EXPORT, false);
}
/// <summary>
/// Implement this method if Power Tool supports export/import functionality.
/// Declaration of this method is mandatory.
/// </summary>
/// <param name="datafolderpath">Powertool import location.</param>
public void Import(string datafolderpath) {
/*For example, to import a powertool using MSDE/MYSQL, use
the below commented code*/
//Use code below to import msde databases
/*ActionCollection actions = new ActionCollection();
actions += new CreateMSDEDB();
actions += new ImportMSDEDB( datafolderpath,
instanceData["sqldbuser"].ToString());*/
//Use code below to import mysql databases
/*string oldptdatapath = String.Format(@"{0}\{1}",
datafolderpath, instanceData["dbname"].ToString());
if(Directory.Exists(oldptdatapath)) {
actions += new CreateDB();
actions += new ImportTables( datafolderpath );
}*/
//Use the code below to remove the power tool files, if any, copied by the w3svc service.
/*actions += new RemoveWebDir(instanceData["url_path"] );
actions += new RemoveToolFiles();*/
//Use the code below to restore power tool files, from import location to the site data location
/*actions += new
CreateWebDir(instanceData["url_path"].ToString(), true );
actions += new CopyToolFiles( datafolderpath );*/
//Use the code below, if power tool needs to set any iis meta properties while importing.
//For example, if the tool needs to add default.aspx to the "defaultdoc" metapropoerty
/*Hashtable appendProperties = new Hashtable();
appendProperties.Add("DefaultDoc", ",default.aspx");
actions += new
SetDefaultProperties(instanceData["url_path"].ToString(),
appendProperties, null);*/
//Use the code below, if power tool needs to set any file permissions on the power tool install location.
/*PermissionsInfo[] pi = new PermissionsInfo[1];
pi[0] = new PermissionsInfo(this.anonUser,
AccessMask.Write | AccessMask.Read | AccessMask.Modify);
actions += new
SetPermission(instanceData["install_loc"].ToString(), pi,
PermissionActionType.ADD, true);*/
//Use code below to execute all above actions
/*ExecuteActions(actions, ActionType.IMPORT, false);*/
}
/// <summary>
/// If the custom Power Tool requires .Net, then the implementation to handle ASP.Net version change is as follows:
/// </summary>
/// <param name="Add">If ASP.Net version is changed to "1.1.4322.0" the value is true.
/// If ASP.Net version is changed to "2.0.50727.0" the value is false.
///</param>
public void HandleASPNetVersionChange(bool Add){
}
}
}